/* brush-params.h
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#ifndef N96_DRAW_brush_params_h
#define N96_DRAW_brush_params_h

typedef enum Brushtype Brushtype;
typedef enum Scattertype Scattertype;
typedef struct BrushParams BrushParams;
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
enum Brushtype {
	BRUSHTYPE_CIRCLE1,
	BRUSHTYPE_CIRCLE1NOISE,
	BRUSHTYPE_CIRCLE2,
	BRUSHTYPE_RANDSQUARE,
};

enum Scattertype {
	SCATTERTYPE_NONE,
	SCATTERTYPE_CIRCLE,
	SCATTERTYPE_SQUARE,
};

struct BrushParams {
	int siz;
	Brushtype type;
	_Bool pressure_size;
	double opacity;
	double softness;
	double aaradius_circle1;
	Scattertype scatter_type;
	double scatter_radius;
	double scatter_density;
	_Bool scatter_take_pressure;
};

BrushParams brush_params_default();

#endif /* N96_DRAW_brush_params_h */
