/* brushes.c
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#include <assert.h>
#include <stdarg.h>
#include <stdbool.h>

#include "brushes.h"

BrushParams prebrush_default()
{
	BrushParams preset = brush_params_default();

	preset.opacity = 1;
	preset.aaradius_circle1 = 2;
	preset.scatter_density = 1.5;
	preset.scatter_radius = 1;

	return preset;
}

BrushParams prebrush_ballpoint()
{
	BrushParams preset = prebrush_default();

	preset.type = BRUSHTYPE_CIRCLE1;
	preset.siz = 2;
	preset.aaradius_circle1 = 1.25;

	return preset;
}

BrushParams prebrush_charcoal()
{
	BrushParams preset = prebrush_default();

	preset.type = BRUSHTYPE_RANDSQUARE;
	preset.pressure_size = true;
	preset.siz = 16;

	return preset;
}

BrushParams prebrush_crayon()
{
	BrushParams preset = prebrush_default();

	preset.type = BRUSHTYPE_CIRCLE1;
	preset.siz = 3;
	preset.scatter_type = SCATTERTYPE_SQUARE;
	preset.scatter_density = 2;
	preset.scatter_radius = 0.75;

	return preset;
}

BrushParams prebrush_pencil()
{
	BrushParams preset = prebrush_default();

	preset.type = BRUSHTYPE_CIRCLE1;
	preset.siz = 2;
	preset.scatter_type = SCATTERTYPE_SQUARE;
	preset.scatter_density = 4;
	preset.scatter_radius = 0.5;

	return preset;
}

BrushParams prebrush_round()
{
	BrushParams preset = prebrush_default();

	preset.type = BRUSHTYPE_CIRCLE1;
	preset.siz = 8;
	preset.aaradius_circle1 = 1.5;

	return preset;
}

BrushParams prebrush_round_pressure_size()
{
	BrushParams preset = prebrush_round();

	preset.pressure_size = true;
	preset.siz += 8;
	preset.aaradius_circle1 = 1.5;

	return preset;
}

BrushParams prebrush_soft_round()
{
	BrushParams preset = prebrush_round();

	preset.siz += 2;
	preset.softness = 0.9;
	preset.opacity = 0.1;

	return preset;
}
