/* entryslider.c
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#include <assert.h>
#include <stdarg.h>
#include <stdbool.h>

#include "entryslider.h"


void entry_slider_construct(EntrySlider *this)
{
	this->grd = (GtkGrid *) gtk_grid_new();
	this->lbl = (GtkLabel *) gtk_label_new(NULL);
	this->spnbtn = (GtkSpinButton *) gtk_spin_button_new(NULL, 0.1, 2u);
	this->sldr = (GtkScale *) gtk_scale_new(GTK_ORIENTATION_HORIZONTAL, NULL);
	this->set_by_code = false;
	this->changed_data = NULL;
	this->changed_callback = NULL;
	gtk_grid_attach(this->grd, (GtkWidget *) this->lbl, 0, 0, 1, 1);
	gtk_widget_set_halign((GtkWidget *) this->lbl, GTK_ALIGN_START);
	gtk_widget_set_size_request((GtkWidget *) this->lbl, 160, -1);
	gtk_widget_show((GtkWidget *) this->lbl);
	gtk_grid_attach(this->grd, (GtkWidget *) this->spnbtn, 1, 0, 1, 1);
	gtk_spin_button_set_digits(this->spnbtn, (unsigned int) 2);
	g_signal_connect((GtkWidget *) this->spnbtn, "value-changed", G_CALLBACK(entry_slider_on_spnbtn_changed), this);
	gtk_widget_show((GtkWidget *) this->spnbtn);
	gtk_grid_attach(this->grd, (GtkWidget *) this->sldr, 0, 1, 2, 1);
	gtk_scale_set_draw_value(this->sldr, false);
	gtk_widget_show((GtkWidget *) this->sldr);
	gtk_widget_show((GtkWidget *) this->grd);

	entry_slider_set_range(this, 0, 1);
	entry_slider_set_increments(this, 0.01, 0.1);
	g_object_bind_property(this->spnbtn, "value", gtk_range_get_adjustment((GtkRange *) this->sldr), "value", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE);
}

GtkGrid * entry_slider_get_native_widget(EntrySlider *this)
{
	return this->grd;
}

_Bool entry_slider_get_sensitive(EntrySlider *this)
{
	return gtk_widget_get_sensitive((GtkWidget *) this->grd);
}

double entry_slider_get_value(EntrySlider *this)
{
	return gtk_spin_button_get_value(this->spnbtn);
}

void entry_slider_set_digits(EntrySlider *this, int digits)
{
	gtk_scale_set_digits(this->sldr, digits);
	gtk_spin_button_set_digits(this->spnbtn, (unsigned int) digits);
}

void entry_slider_set_increments(EntrySlider *this, double stp, double page)
{
	gtk_spin_button_set_increments(this->spnbtn, stp, page);
}

void entry_slider_set_label(EntrySlider *this, const char * s)
{
	gtk_label_set_label(this->lbl, s);
}

void entry_slider_set_round_digits(EntrySlider *this, _Bool round)
{
	gtk_range_set_round_digits((GtkRange *) this->sldr, round);
}

void entry_slider_set_sensitive(EntrySlider *this, _Bool sensitive)
{
	gtk_widget_set_sensitive((GtkWidget *) this->grd, sensitive);
}

void entry_slider_set_value(EntrySlider *this, double value)
{
	gtk_spin_button_set_value(this->spnbtn, value);
}

void entry_slider_set_value_by_code(EntrySlider *this, double value)
{
	this->set_by_code = true;
	gtk_spin_button_set_value(this->spnbtn, value);
	this->set_by_code = false;
}

void entry_slider_set_onchanged(EntrySlider *this, void (*callback)(EntrySlider *widget, void *user_data), void *user_data)
{
	this->changed_callback = callback;
	this->changed_data = user_data;
}

void entry_slider_set_range(EntrySlider *this, double min, double max)
{
	gtk_range_set_range((GtkRange *) this->sldr, min, max);
	gtk_spin_button_set_range(this->spnbtn, min, max);
}

void entry_slider_show(EntrySlider *this)
{
	gtk_widget_show_all((GtkWidget *) this->grd);
}

void entry_slider_on_spnbtn_changed(GtkSpinButton *widget, void *user_data)
{
	if(((EntrySlider *) user_data)->set_by_code) {
		return;
	}

	if(((EntrySlider *) user_data)->changed_callback) {
		void (*callbacknn)(EntrySlider *widget, void *user_data);
		callbacknn = (void (*)(EntrySlider *widget, void *user_data)) ((EntrySlider *) user_data)->changed_callback;
		callbacknn(((EntrySlider *) user_data), ((EntrySlider *) user_data)->changed_data);
	}
}

void entry_slider_destruct(EntrySlider *this)
{
}
