/* entryslider.h
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#ifndef N96_DRAW_entryslider_h
#define N96_DRAW_entryslider_h

typedef struct EntrySlider EntrySlider;
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "commongui.h"
#include "commongui.h"
struct EntrySlider {
	GtkScale *sldr;
	GtkSpinButton *spnbtn;
	GtkLabel *lbl;
	GtkGrid *grd;
	void (*changed_callback)(EntrySlider *widget, void *user_data);
	void *changed_data;
	_Bool set_by_code;
};

void entry_slider_construct(EntrySlider *this);
GtkGrid * entry_slider_get_native_widget(EntrySlider *this);
_Bool entry_slider_get_sensitive(EntrySlider *this);
double entry_slider_get_value(EntrySlider *this);
void entry_slider_set_digits(EntrySlider *this, int digits);
void entry_slider_set_increments(EntrySlider *this, double stp, double page);
void entry_slider_set_label(EntrySlider *this, const char * s);
void entry_slider_set_round_digits(EntrySlider *this, _Bool round);
void entry_slider_set_sensitive(EntrySlider *this, _Bool sensitive);
void entry_slider_set_value(EntrySlider *this, double value);
void entry_slider_set_value_by_code(EntrySlider *this, double value);
void entry_slider_set_onchanged(EntrySlider *this, void (*callback)(EntrySlider *widget, void *user_data), void *user_data);
void entry_slider_set_range(EntrySlider *this, double min, double max);
void entry_slider_show(EntrySlider *this);
void entry_slider_on_spnbtn_changed(GtkSpinButton *widget, void *user_data);
void entry_slider_destruct(EntrySlider *this);

#endif /* N96_DRAW_entryslider_h */
