/* floodfill.h
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#ifndef N96_DRAW_floodfill_h
#define N96_DRAW_floodfill_h

typedef struct Point Point;
typedef struct PointStack PointStack;
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "core.h"
#include "core.h"
struct Point {
	int x;
	int y;
};

struct PointStack {
	Point *arr;
	int count;
	int alloccount;
};

int point_stack_get_count(PointStack *this);
_Bool point_stack_is_empty(PointStack *this);
void point_stack_push(PointStack *this, Point newitem);
void point_stack_push_multiple(PointStack *this, int n, Point *newitems);
Point point_stack_peek(PointStack *this);
Point point_stack_pop(PointStack *this);
Point point_stack_pop_bottom(PointStack *this);
void point_stack_replace_top(PointStack *this, Point newitem);
void point_stack__resize(PointStack *this, int newcount);
void point_stack_destruct(PointStack *this);
void point_stack_construct(PointStack *this);
VaraRect nan_img_floodfill(Image *img, int x, int y, DrawingParams dp);
void floodfill_add_point_to_stack_if_match(Image *img, PointStack *ptstack, Point point, LinearPixel ifpxl);
Point point_default();

#endif /* N96_DRAW_floodfill_h */
