/* helpmenuitem.c
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#include <assert.h>
#include <stdarg.h>
#include <stdbool.h>

#include "helpmenuitem.h"


void help_menu_item_construct(HelpMenuItem *this, const char * title, const char * message)
{
	this->mni = (GtkMenuItem *) gtk_menu_item_new();
	this->title = title;

	this->message = message;

	gtk_menu_item_set_label(this->mni, title);
	gtk_menu_item_set_use_underline(this->mni, true);
	g_signal_connect((GtkWidget *) this->mni, "activate", G_CALLBACK(help_menu_item_on_mni_help_item_activate), this);
	gtk_widget_show((GtkWidget *) this->mni);
}

GtkMenuItem * help_menu_item_get_native_widget(HelpMenuItem *this)
{
	return this->mni;
}

void help_menu_item_show(HelpMenuItem *this)
{
	gtk_widget_show((GtkWidget *) this->mni);
}

void help_menu_item_on_mni_help_item_activate(GtkMenuItem *widget, void *user_data)
{
	GtkWidget *toplevel = gtk_widget_get_toplevel((GtkWidget *) ((HelpMenuItem *) user_data)->mni);

	GtkWindow *_tmp_1;
	if(GTK_IS_WINDOW(toplevel)) {
		_tmp_1 = GTK_WINDOW(toplevel);
	} else {
		_tmp_1 = NULL;
	}

	GtkDialog *dlg = (GtkDialog *) gtk_message_dialog_new(_tmp_1, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "%s", ((HelpMenuItem *) user_data)->message);

	int _ngg_tmp_15;
	int res = gtk_dialog_run(dlg);
	gtk_widget_destroy((GtkWidget *) dlg);
	_ngg_tmp_15 = res;
}

void help_menu_item_destruct(HelpMenuItem *this)
{
}
