/* image-cairo.h
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#ifndef N96_DRAW_image_cairo_h
#define N96_DRAW_image_cairo_h

typedef enum VaraFileIOError VaraFileIOError;
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <cairo.h>
#include "cairo.h"
#include "core.h"
#include "core.h"
enum VaraFileIOError {
	VARA_FILE_I_O_ERROR_SUCCESS,
	VARA_FILE_I_O_ERROR_OTHER,
};

void copy_image_to_cairo_surface_argb32(Image *img, cairo_surface_t *surf);
void copy_image_region_to_cairo_surface(Image *img, cairo_surface_t *surf, VaraRect rect);
VaraFileIOError write_image_to_png(Image *img, const char * fname);

#endif /* N96_DRAW_image_cairo_h */
