/* imageview.h
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#ifndef N96_DRAW_imageview_h
#define N96_DRAW_imageview_h

typedef struct _ngg_vtab_t_ImageView _ngg_vtab_t_ImageView;
typedef struct ImageView ImageView;
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "commongui.h"
#include "commongui.h"
#include "image-cairo.h"
#include "image-cairo.h"
typedef struct ImageView ImageView;
struct _ngg_vtab_t_ImageView {
	void (*destruct)(ImageView *this);
};

struct ImageView {
	GtkDrawingArea *da;
	_ngg_vtab_t_ImageView _ngg_vtab_image_view;
	Image *img;
	cairo_surface_t *surf;
	_Bool autoresize;
};

void image_view_construct(ImageView *this);
GtkWidget * image_view_get_native_widget(ImageView *this);
void image_view_on_da_destroy(GtkWidget *widget, void *user_data);
void image_view_on_da_draw(GtkDrawingArea *widget, cairo_t *nggevent_cr, void *user_data);
void image_view_set_image(ImageView *this, Image *img);
void image_view_queue_draw(ImageView *this);
void image_view_show(ImageView *this);
void image_view__nggnonvirt_destruct(ImageView *this);
void image_view_destruct(ImageView *this);

#endif /* N96_DRAW_imageview_h */
