/* inputdialog.c
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#include <assert.h>
#include <stdarg.h>
#include <stdbool.h>

#include "inputdialog.h"


void input_dialog_response_construct(InputDialogResponse *this, _Bool ok, char * name)
{
	this->ok = ok;
	this->name = name;
}

void input_dialog_response_destruct(InputDialogResponse *this)
{
}

void input_dialog_construct(InputDialog *this, GtkWindow *parent, const char * title, const char * label)
{
	this->dlg = (GtkDialog *) gtk_dialog_new();
	GtkBox *_ngg_tmp_15;
	GtkBox *bx = (GtkBox *) gtk_box_new(GTK_ORIENTATION_VERTICAL, 4);
	gtk_container_set_border_width((GtkContainer *) bx, (unsigned int) 4);
	_ngg_tmp_15 = bx;
	this->vbx_main = _ngg_tmp_15;
	GtkBox *_ngg_tmp_16;
	GtkBox *_ngg_tmp_18_bx = (GtkBox *) gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 4);
	gtk_container_set_border_width((GtkContainer *) _ngg_tmp_18_bx, (unsigned int) 4);
	_ngg_tmp_16 = _ngg_tmp_18_bx;
	this->hbx_name = _ngg_tmp_16;
	this->lbl_name = (GtkLabel *) gtk_label_new(NULL);
	this->entry_name = (GtkEntry *) gtk_entry_new();
	gtk_window_set_title((GtkWindow *) this->dlg, title);
	gtk_window_set_resizable((GtkWindow *) this->dlg, false);
	gtk_dialog_add_button(this->dlg, "Cancel", GTK_RESPONSE_REJECT);
	gtk_dialog_add_button(this->dlg, "Create", GTK_RESPONSE_ACCEPT);
	gtk_dialog_set_default_response(this->dlg, GTK_RESPONSE_ACCEPT);
	gtk_window_set_transient_for((GtkWindow *) this->dlg, parent);
	gtk_widget_set_visible((GtkWidget *) this->dlg, false);
	gtk_container_add((GtkContainer *) ((GtkBox *) gtk_dialog_get_content_area(this->dlg)), (GtkWidget *) this->vbx_main);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->vbx_main), GTK_WIDGET((GtkWidget *) this->hbx_name));
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->hbx_name), GTK_WIDGET((GtkWidget *) this->lbl_name));
	gtk_label_set_label(this->lbl_name, label);
	gtk_widget_show((GtkWidget *) this->lbl_name);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->hbx_name), GTK_WIDGET((GtkWidget *) this->entry_name));
	gtk_widget_set_hexpand((GtkWidget *) this->entry_name, true);
	gtk_widget_show((GtkWidget *) this->entry_name);
	gtk_widget_show((GtkWidget *) this->hbx_name);
	gtk_widget_show((GtkWidget *) this->vbx_main);

	gtk_widget_grab_focus((GtkWidget *) this->entry_name);
}

void input_dialog_destruct(InputDialog *this)
{
	if(this->dlg) {
		gtk_widget_destroy((GtkWidget *) this->dlg);
	}
}

InputDialogResponse * input_dialog_run(InputDialog *this)
{
	assert(this->dlg); /* inputdialog.ngg:33 */

	int res = gtk_dialog_run(this->dlg);
	gtk_widget_set_visible((GtkWidget *) this->dlg, false);

	if(res == GTK_RESPONSE_ACCEPT) {
		InputDialogResponse *_tmp_1 = (InputDialogResponse *) malloc(sizeof(InputDialogResponse));
		if(_tmp_1 == NULL) {
			perror(NULL);
			exit(EXIT_FAILURE);
		}

		char * _ngg_tmp_19;
		char * _ngg_tmp_0;
		const char * _tmp_4 = gtk_entry_get_text(this->entry_name);
		char *_ngg_tmp_2__tmp_2 = (char *) calloc((size_t) (strlen(_tmp_4) + (1u)), sizeof(char));
		if(_ngg_tmp_2__tmp_2 == NULL) {
			perror(NULL);
			exit(EXIT_FAILURE);
		}

		char * _ngg_tmp_4__tmp_1 = (char *) _ngg_tmp_2__tmp_2;
		memcpy(_ngg_tmp_4__tmp_1, _tmp_4, strlen(_tmp_4) + (1u));
		_ngg_tmp_0 = _ngg_tmp_4__tmp_1;
		char * _ngg_tmp_21__tmp_1 = _ngg_tmp_0;
		char *_tmp_3 = (char *) calloc((size_t) (strlen(_ngg_tmp_21__tmp_1) + (1u)), sizeof(char));
		if(_tmp_3 == NULL) {
			perror(NULL);
			exit(EXIT_FAILURE);
		}

		char * _tmp_2 = (char *) _tmp_3;
		memcpy(_tmp_2, _ngg_tmp_21__tmp_1, strlen(_ngg_tmp_21__tmp_1) + (1u));
		_ngg_tmp_19 = _tmp_2;
		input_dialog_response_construct(_tmp_1, true, _ngg_tmp_19);
		return _tmp_1;
	}

	InputDialogResponse *_tmp_1 = (InputDialogResponse *) malloc(sizeof(InputDialogResponse));
	if(_tmp_1 == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	input_dialog_response_construct(_tmp_1, false, NULL);
	return _tmp_1;
}
