/* inst.c
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#include <assert.h>
#include <stdarg.h>
#include <stdbool.h>

#include "inst.h"

int _ngg_clsid_Instruction = 0;
void instruction__nggnonvirt_destruct(Instruction *this)
{
}

void instruction_destruct(Instruction *this)
{
	this->_ngg_vtab_instruction.destruct(this);
}

void instruction_construct(Instruction *this)
{
	this->_ngg_clsid_final = &_ngg_clsid_Instruction;
	this->_ngg_vtab_instruction.destruct = (void (*)(Instruction *this)) instruction__nggnonvirt_destruct;
}

int _ngg_clsid_DrawDotPerc = 0;
void draw_dot_perc_construct(DrawDotPerc *this, double x, double y, double p)
{
	instruction_construct((Instruction *) this);
	this->_ngg_clsid_final = &_ngg_clsid_DrawDotPerc;
	this->_ngg_vtab_instruction.destruct = (void (*)(Instruction *this)) draw_dot_perc__nggnonvirt_destruct;
	this->x = x;
	this->y = y;
	this->p = p;
}

void draw_dot_perc__nggnonvirt_destruct(DrawDotPerc *this)
{
	instruction__nggnonvirt_destruct((Instruction *) this);
}

int _ngg_clsid_DrawLinePerc = 0;
void draw_line_perc_construct(DrawLinePerc *this, double x1, double y1, double p1, double x2, double y2, double p2)
{
	instruction_construct((Instruction *) this);
	this->_ngg_clsid_final = &_ngg_clsid_DrawLinePerc;
	this->_ngg_vtab_instruction.destruct = (void (*)(Instruction *this)) draw_line_perc__nggnonvirt_destruct;
	this->x1 = x1;
	this->y1 = y1;
	this->p1 = p1;
	this->x2 = x2;
	this->y2 = y2;
	this->p2 = p2;
}

void draw_line_perc__nggnonvirt_destruct(DrawLinePerc *this)
{
	instruction__nggnonvirt_destruct((Instruction *) this);
}

int _ngg_clsid_DrawVgradient = 0;
void draw_vgradient_construct(DrawVgradient *this, double yfrom, double yto, double stp, double rfac, double gfac, double bfac, double opacity, _Bool absolutergb)
{
	instruction_construct((Instruction *) this);
	this->_ngg_clsid_final = &_ngg_clsid_DrawVgradient;
	this->_ngg_vtab_instruction.destruct = (void (*)(Instruction *this)) draw_vgradient__nggnonvirt_destruct;
	this->yfrom = yfrom;
	this->yto = yto;
	this->stp = stp;
	this->rfac = rfac;
	this->gfac = gfac;
	this->bfac = bfac;
	this->opacity = opacity;
	this->absolutergb = absolutergb;
}

void draw_vgradient__nggnonvirt_destruct(DrawVgradient *this)
{
	instruction__nggnonvirt_destruct((Instruction *) this);
}

int _ngg_clsid_SelectBrushPreset = 0;
void select_brush_preset_construct(SelectBrushPreset *this, int presetidx)
{
	instruction_construct((Instruction *) this);
	this->_ngg_clsid_final = &_ngg_clsid_SelectBrushPreset;
	this->_ngg_vtab_instruction.destruct = (void (*)(Instruction *this)) select_brush_preset__nggnonvirt_destruct;
	this->presetidx = presetidx;
}

void select_brush_preset__nggnonvirt_destruct(SelectBrushPreset *this)
{
	instruction__nggnonvirt_destruct((Instruction *) this);
}

int _ngg_clsid_SelectBrushTool = 0;
void select_brush_tool__nggnonvirt_destruct(SelectBrushTool *this)
{
	instruction__nggnonvirt_destruct((Instruction *) this);
}

void select_brush_tool_construct(SelectBrushTool *this)
{
	instruction_construct((Instruction *) this);
	this->_ngg_clsid_final = &_ngg_clsid_SelectBrushTool;
	this->_ngg_vtab_instruction.destruct = (void (*)(Instruction *this)) select_brush_tool__nggnonvirt_destruct;
}

int _ngg_clsid_SelectFloodfillTool = 0;
void select_floodfill_tool__nggnonvirt_destruct(SelectFloodfillTool *this)
{
	instruction__nggnonvirt_destruct((Instruction *) this);
}

void select_floodfill_tool_construct(SelectFloodfillTool *this)
{
	instruction_construct((Instruction *) this);
	this->_ngg_clsid_final = &_ngg_clsid_SelectFloodfillTool;
	this->_ngg_vtab_instruction.destruct = (void (*)(Instruction *this)) select_floodfill_tool__nggnonvirt_destruct;
}

int _ngg_clsid_SelectPencilBrushPreset = 0;
void select_pencil_brush_preset__nggnonvirt_destruct(SelectPencilBrushPreset *this)
{
	instruction__nggnonvirt_destruct((Instruction *) this);
}

void select_pencil_brush_preset_construct(SelectPencilBrushPreset *this)
{
	instruction_construct((Instruction *) this);
	this->_ngg_clsid_final = &_ngg_clsid_SelectPencilBrushPreset;
	this->_ngg_vtab_instruction.destruct = (void (*)(Instruction *this)) select_pencil_brush_preset__nggnonvirt_destruct;
}

int _ngg_clsid_SelectRoundBrushPreset = 0;
void select_round_brush_preset__nggnonvirt_destruct(SelectRoundBrushPreset *this)
{
	instruction__nggnonvirt_destruct((Instruction *) this);
}

void select_round_brush_preset_construct(SelectRoundBrushPreset *this)
{
	instruction_construct((Instruction *) this);
	this->_ngg_clsid_final = &_ngg_clsid_SelectRoundBrushPreset;
	this->_ngg_vtab_instruction.destruct = (void (*)(Instruction *this)) select_round_brush_preset__nggnonvirt_destruct;
}

int _ngg_clsid_SelectSoftRoundBrushPreset = 0;
void select_soft_round_brush_preset__nggnonvirt_destruct(SelectSoftRoundBrushPreset *this)
{
	instruction__nggnonvirt_destruct((Instruction *) this);
}

void select_soft_round_brush_preset_construct(SelectSoftRoundBrushPreset *this)
{
	instruction_construct((Instruction *) this);
	this->_ngg_clsid_final = &_ngg_clsid_SelectSoftRoundBrushPreset;
	this->_ngg_vtab_instruction.destruct = (void (*)(Instruction *this)) select_soft_round_brush_preset__nggnonvirt_destruct;
}

int _ngg_clsid_SetBrushOpacity = 0;
void set_brush_opacity_construct(SetBrushOpacity *this, double opacity)
{
	instruction_construct((Instruction *) this);
	this->_ngg_clsid_final = &_ngg_clsid_SetBrushOpacity;
	this->_ngg_vtab_instruction.destruct = (void (*)(Instruction *this)) set_brush_opacity__nggnonvirt_destruct;
	this->opacity = opacity;
}

void set_brush_opacity__nggnonvirt_destruct(SetBrushOpacity *this)
{
	instruction__nggnonvirt_destruct((Instruction *) this);
}

int _ngg_clsid_SetBrushPressureForSize = 0;
void set_brush_pressure_for_size_construct(SetBrushPressureForSize *this, _Bool use_pressure)
{
	instruction_construct((Instruction *) this);
	this->_ngg_clsid_final = &_ngg_clsid_SetBrushPressureForSize;
	this->_ngg_vtab_instruction.destruct = (void (*)(Instruction *this)) set_brush_pressure_for_size__nggnonvirt_destruct;
	this->use_pressure = use_pressure;
}

void set_brush_pressure_for_size__nggnonvirt_destruct(SetBrushPressureForSize *this)
{
	instruction__nggnonvirt_destruct((Instruction *) this);
}

int _ngg_clsid_SetFillSizePerc = 0;
void set_fill_size_perc_construct(SetFillSizePerc *this, double sizeperc)
{
	instruction_construct((Instruction *) this);
	this->_ngg_clsid_final = &_ngg_clsid_SetFillSizePerc;
	this->_ngg_vtab_instruction.destruct = (void (*)(Instruction *this)) set_fill_size_perc__nggnonvirt_destruct;
	this->sizeperc = sizeperc;
}

void set_fill_size_perc__nggnonvirt_destruct(SetFillSizePerc *this)
{
	instruction__nggnonvirt_destruct((Instruction *) this);
}

int _ngg_clsid_SetStrokeColorSrgb = 0;
void set_stroke_color_srgb_construct(SetStrokeColorSrgb *this, double r, double g, double b)
{
	instruction_construct((Instruction *) this);
	this->_ngg_clsid_final = &_ngg_clsid_SetStrokeColorSrgb;
	this->_ngg_vtab_instruction.destruct = (void (*)(Instruction *this)) set_stroke_color_srgb__nggnonvirt_destruct;
	this->r = r;
	this->g = g;
	this->b = b;
}

void set_stroke_color_srgb__nggnonvirt_destruct(SetStrokeColorSrgb *this)
{
	instruction__nggnonvirt_destruct((Instruction *) this);
}
