/* inst.h
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#ifndef N96_DRAW_inst_h
#define N96_DRAW_inst_h

typedef struct _ngg_vtab_t_Instruction _ngg_vtab_t_Instruction;
typedef struct Instruction Instruction;
typedef struct DrawDotPerc DrawDotPerc;
typedef struct DrawLinePerc DrawLinePerc;
typedef struct DrawVgradient DrawVgradient;
typedef struct SelectBrushPreset SelectBrushPreset;
typedef struct SelectBrushTool SelectBrushTool;
typedef struct SelectFloodfillTool SelectFloodfillTool;
typedef struct SelectPencilBrushPreset SelectPencilBrushPreset;
typedef struct SelectRoundBrushPreset SelectRoundBrushPreset;
typedef struct SelectSoftRoundBrushPreset SelectSoftRoundBrushPreset;
typedef struct SetBrushOpacity SetBrushOpacity;
typedef struct SetBrushPressureForSize SetBrushPressureForSize;
typedef struct SetFillSizePerc SetFillSizePerc;
typedef struct SetStrokeColorSrgb SetStrokeColorSrgb;
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
extern int _ngg_clsid_Instruction;
typedef struct Instruction Instruction;
struct _ngg_vtab_t_Instruction {
	void (*destruct)(Instruction *this);
};

struct Instruction {
	int *_ngg_clsid_final;
	_ngg_vtab_t_Instruction _ngg_vtab_instruction;
};

extern int _ngg_clsid_DrawDotPerc;
struct DrawDotPerc {
	int *_ngg_clsid_final;
	_ngg_vtab_t_Instruction _ngg_vtab_instruction;
	double x;
	double y;
	double p;
};

extern int _ngg_clsid_DrawLinePerc;
struct DrawLinePerc {
	int *_ngg_clsid_final;
	_ngg_vtab_t_Instruction _ngg_vtab_instruction;
	double x1;
	double y1;
	double p1;
	double x2;
	double y2;
	double p2;
};

extern int _ngg_clsid_DrawVgradient;
struct DrawVgradient {
	int *_ngg_clsid_final;
	_ngg_vtab_t_Instruction _ngg_vtab_instruction;
	double yfrom;
	double yto;
	double stp;
	double rfac;
	double gfac;
	double bfac;
	double opacity;
	_Bool absolutergb;
};

extern int _ngg_clsid_SelectBrushPreset;
struct SelectBrushPreset {
	int *_ngg_clsid_final;
	_ngg_vtab_t_Instruction _ngg_vtab_instruction;
	int presetidx;
};

extern int _ngg_clsid_SelectBrushTool;
struct SelectBrushTool {
	int *_ngg_clsid_final;
	_ngg_vtab_t_Instruction _ngg_vtab_instruction;
};

extern int _ngg_clsid_SelectFloodfillTool;
struct SelectFloodfillTool {
	int *_ngg_clsid_final;
	_ngg_vtab_t_Instruction _ngg_vtab_instruction;
};

extern int _ngg_clsid_SelectPencilBrushPreset;
struct SelectPencilBrushPreset {
	int *_ngg_clsid_final;
	_ngg_vtab_t_Instruction _ngg_vtab_instruction;
};

extern int _ngg_clsid_SelectRoundBrushPreset;
struct SelectRoundBrushPreset {
	int *_ngg_clsid_final;
	_ngg_vtab_t_Instruction _ngg_vtab_instruction;
};

extern int _ngg_clsid_SelectSoftRoundBrushPreset;
struct SelectSoftRoundBrushPreset {
	int *_ngg_clsid_final;
	_ngg_vtab_t_Instruction _ngg_vtab_instruction;
};

extern int _ngg_clsid_SetBrushOpacity;
struct SetBrushOpacity {
	int *_ngg_clsid_final;
	_ngg_vtab_t_Instruction _ngg_vtab_instruction;
	double opacity;
};

extern int _ngg_clsid_SetBrushPressureForSize;
struct SetBrushPressureForSize {
	int *_ngg_clsid_final;
	_ngg_vtab_t_Instruction _ngg_vtab_instruction;
	_Bool use_pressure;
};

extern int _ngg_clsid_SetFillSizePerc;
struct SetFillSizePerc {
	int *_ngg_clsid_final;
	_ngg_vtab_t_Instruction _ngg_vtab_instruction;
	double sizeperc;
};

extern int _ngg_clsid_SetStrokeColorSrgb;
struct SetStrokeColorSrgb {
	int *_ngg_clsid_final;
	_ngg_vtab_t_Instruction _ngg_vtab_instruction;
	double r;
	double g;
	double b;
};

void instruction__nggnonvirt_destruct(Instruction *this);
void instruction_destruct(Instruction *this);
void instruction_construct(Instruction *this);
void draw_dot_perc_construct(DrawDotPerc *this, double x, double y, double p);
void draw_dot_perc__nggnonvirt_destruct(DrawDotPerc *this);
void draw_line_perc_construct(DrawLinePerc *this, double x1, double y1, double p1, double x2, double y2, double p2);
void draw_line_perc__nggnonvirt_destruct(DrawLinePerc *this);
void draw_vgradient_construct(DrawVgradient *this, double yfrom, double yto, double stp, double rfac, double gfac, double bfac, double opacity, _Bool absolutergb);
void draw_vgradient__nggnonvirt_destruct(DrawVgradient *this);
void select_brush_preset_construct(SelectBrushPreset *this, int presetidx);
void select_brush_preset__nggnonvirt_destruct(SelectBrushPreset *this);
void select_brush_tool__nggnonvirt_destruct(SelectBrushTool *this);
void select_brush_tool_construct(SelectBrushTool *this);
void select_floodfill_tool__nggnonvirt_destruct(SelectFloodfillTool *this);
void select_floodfill_tool_construct(SelectFloodfillTool *this);
void select_pencil_brush_preset__nggnonvirt_destruct(SelectPencilBrushPreset *this);
void select_pencil_brush_preset_construct(SelectPencilBrushPreset *this);
void select_round_brush_preset__nggnonvirt_destruct(SelectRoundBrushPreset *this);
void select_round_brush_preset_construct(SelectRoundBrushPreset *this);
void select_soft_round_brush_preset__nggnonvirt_destruct(SelectSoftRoundBrushPreset *this);
void select_soft_round_brush_preset_construct(SelectSoftRoundBrushPreset *this);
void set_brush_opacity_construct(SetBrushOpacity *this, double opacity);
void set_brush_opacity__nggnonvirt_destruct(SetBrushOpacity *this);
void set_brush_pressure_for_size_construct(SetBrushPressureForSize *this, _Bool use_pressure);
void set_brush_pressure_for_size__nggnonvirt_destruct(SetBrushPressureForSize *this);
void set_fill_size_perc_construct(SetFillSizePerc *this, double sizeperc);
void set_fill_size_perc__nggnonvirt_destruct(SetFillSizePerc *this);
void set_stroke_color_srgb_construct(SetStrokeColorSrgb *this, double r, double g, double b);
void set_stroke_color_srgb__nggnonvirt_destruct(SetStrokeColorSrgb *this);

#endif /* N96_DRAW_inst_h */
