/* layer.c
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#include <assert.h>
#include <stdarg.h>
#include <stdbool.h>

#include "layer.h"

void layer_construct(Layer *this, const char * name, int width, int height, LinearPixel default_bgcolor)
{
	char *_tmp_3 = (char *) calloc((size_t) (strlen(name) + (1u)), sizeof(char));
	if(_tmp_3 == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	char * _tmp_1 = (char *) _tmp_3;
	memcpy(_tmp_1, name, strlen(name) + (1u));
	this->name = _tmp_1;
	this->default_bgcolor = default_bgcolor;
	this->alpha = 1;
	this->visible = true;

	Image *_tmp_2 = (Image *) malloc(sizeof(Image));
	if(_tmp_2 == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	image_construct(_tmp_2, width, height, 255);
	this->img = _tmp_2;
	image_fill(this->img, default_bgcolor);
}

void layer_rename(Layer *this, const char * newnam)
{
	char *_tmp_2 = (char *) calloc((size_t) (strlen(newnam) + (1u)), sizeof(char));
	if(_tmp_2 == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	char * _tmp_1 = (char *) _tmp_2;
	memcpy(_tmp_1, newnam, strlen(newnam) + (1u));
	char * _ngg_tmp_0 = _tmp_1;
	if(this->name) {
		free(this->name);
	}

	this->name = _ngg_tmp_0;
}

void layer_replace_image(Layer *this, Image *newimg)
{
	Image *_ngg_tmp_1 = newimg;
	if(this->img) {
		image_destruct(this->img);
		free(this->img);
	}

	this->img = _ngg_tmp_1;
}

void layer_set_alpha(Layer *this, double alpha_in)
{
	this->alpha = alpha_in;
}

void layer_set_visible(Layer *this, _Bool visible_in)
{
	this->visible = visible_in;
}

void layer_destruct(Layer *this)
{
	if(this->name) {
		free(this->name);
	}

	if(this->img) {
		image_destruct(this->img);
		free(this->img);
	}
}
