/* layer.h
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#ifndef N96_DRAW_layer_h
#define N96_DRAW_layer_h

typedef struct Layer Layer;
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "core.h"
#include "core.h"
struct Layer {
	char * name;
	Image *img;
	LinearPixel default_bgcolor;
	double alpha;
	_Bool visible;
};

void layer_construct(Layer *this, const char * name, int width, int height, LinearPixel default_bgcolor);
void layer_rename(Layer *this, const char * newnam);
void layer_replace_image(Layer *this, Image *newimg);
void layer_set_alpha(Layer *this, double alpha_in);
void layer_set_visible(Layer *this, _Bool visible_in);
void layer_destruct(Layer *this);

#endif /* N96_DRAW_layer_h */
