/* newdocdialog.c
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#include <assert.h>
#include <stdarg.h>
#include <stdbool.h>

#include "newdocdialog.h"


void new_doc_dialog_construct(NewDocDialog *this, GtkWindow *parent, int maxwidth)
{
	this->dlg = (GtkDialog *) gtk_dialog_new();
	GtkBox *_ngg_tmp_15;
	GtkBox *bx = (GtkBox *) gtk_box_new(GTK_ORIENTATION_VERTICAL, 4);
	gtk_container_set_border_width((GtkContainer *) bx, (unsigned int) 4);
	_ngg_tmp_15 = bx;
	this->vbx_main = _ngg_tmp_15;
	GtkBox *_ngg_tmp_16;
	GtkBox *_ngg_tmp_18_bx = (GtkBox *) gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 4);
	gtk_container_set_border_width((GtkContainer *) _ngg_tmp_18_bx, (unsigned int) 4);
	_ngg_tmp_16 = _ngg_tmp_18_bx;
	this->hbx_presets = _ngg_tmp_16;
	this->btn_preset_fhd = (GtkButton *) gtk_button_new();
	this->btn_preset_a4_150ppi = (GtkButton *) gtk_button_new();
	this->btn_preset_a4_300ppi = (GtkButton *) gtk_button_new();
	this->grd = (GtkGrid *) gtk_grid_new();
	this->lblwidth = (GtkLabel *) gtk_label_new(NULL);
	this->spin_width = (GtkSpinButton *) gtk_spin_button_new(NULL, 0.1, 2u);
	this->lbl2 = (GtkLabel *) gtk_label_new(NULL);
	this->spin_height = (GtkSpinButton *) gtk_spin_button_new(NULL, 0.1, 2u);
	this->btn_swap = (GtkButton *) gtk_button_new();
	this->maxwidth = maxwidth;

	gtk_window_set_title((GtkWindow *) this->dlg, "New Document");
	gtk_window_set_resizable((GtkWindow *) this->dlg, false);
	gtk_dialog_add_button(this->dlg, "Cancel", GTK_RESPONSE_REJECT);
	gtk_dialog_add_button(this->dlg, "Create", GTK_RESPONSE_ACCEPT);
	gtk_dialog_set_default_response(this->dlg, GTK_RESPONSE_ACCEPT);
	gtk_window_set_transient_for((GtkWindow *) this->dlg, parent);
	gtk_widget_set_visible((GtkWidget *) this->dlg, false);
	gtk_container_add((GtkContainer *) ((GtkBox *) gtk_dialog_get_content_area(this->dlg)), (GtkWidget *) this->vbx_main);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->vbx_main), GTK_WIDGET((GtkWidget *) this->hbx_presets));
	gtk_widget_set_halign((GtkWidget *) this->hbx_presets, GTK_ALIGN_CENTER);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->hbx_presets), GTK_WIDGET((GtkWidget *) this->btn_preset_fhd));
	gtk_button_set_label(this->btn_preset_fhd, "FHD");
	g_signal_connect((GtkWidget *) this->btn_preset_fhd, "clicked", G_CALLBACK(new_doc_dialog_on_btn_preset_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_preset_fhd);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->hbx_presets), GTK_WIDGET((GtkWidget *) this->btn_preset_a4_150ppi));
	gtk_button_set_label(this->btn_preset_a4_150ppi, "A4 (150 ppi)");
	g_signal_connect((GtkWidget *) this->btn_preset_a4_150ppi, "clicked", G_CALLBACK(new_doc_dialog_on_btn_preset_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_preset_a4_150ppi);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->hbx_presets), GTK_WIDGET((GtkWidget *) this->btn_preset_a4_300ppi));
	gtk_button_set_label(this->btn_preset_a4_300ppi, "A4 (300 ppi)");
	g_signal_connect((GtkWidget *) this->btn_preset_a4_300ppi, "clicked", G_CALLBACK(new_doc_dialog_on_btn_preset_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_preset_a4_300ppi);
	gtk_widget_show((GtkWidget *) this->hbx_presets);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->vbx_main), GTK_WIDGET((GtkWidget *) this->grd));
	gtk_widget_set_hexpand((GtkWidget *) this->grd, true);
	gtk_grid_attach(this->grd, (GtkWidget *) this->lblwidth, 0, 0, 1, 1);
	gtk_label_set_label(this->lblwidth, "Width (px): ");
	gtk_widget_set_hexpand((GtkWidget *) this->lblwidth, true);
	gtk_widget_set_halign((GtkWidget *) this->lblwidth, GTK_ALIGN_END);
	gtk_widget_show((GtkWidget *) this->lblwidth);
	gtk_grid_attach(this->grd, (GtkWidget *) this->spin_width, 1, 0, 1, 1);
	gtk_spin_button_set_digits(this->spin_width, (unsigned int) 0);
	gtk_entry_set_activates_default((GtkEntry *) this->spin_width, true);
	gtk_widget_show((GtkWidget *) this->spin_width);
	gtk_grid_attach(this->grd, (GtkWidget *) this->lbl2, 0, 1, 1, 1);
	gtk_label_set_label(this->lbl2, "Height (px): ");
	gtk_widget_set_hexpand((GtkWidget *) this->lbl2, true);
	gtk_widget_set_halign((GtkWidget *) this->lbl2, GTK_ALIGN_END);
	gtk_widget_show((GtkWidget *) this->lbl2);
	gtk_grid_attach(this->grd, (GtkWidget *) this->spin_height, 1, 1, 1, 1);
	gtk_spin_button_set_digits(this->spin_height, (unsigned int) 0);
	gtk_entry_set_activates_default((GtkEntry *) this->spin_height, true);
	gtk_widget_show((GtkWidget *) this->spin_height);
	gtk_grid_attach(this->grd, (GtkWidget *) this->btn_swap, 2, 1, 1, 1);
	gtk_button_set_label(this->btn_swap, "Swap");
	g_signal_connect((GtkWidget *) this->btn_swap, "clicked", G_CALLBACK(new_doc_dialog_on_btn_swap_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_swap);
	gtk_widget_show((GtkWidget *) this->grd);
	gtk_widget_show((GtkWidget *) this->vbx_main);

	GtkBox *_tmp_1 = (GtkBox *) gtk_dialog_get_content_area(this->dlg);
	gtk_box_set_spacing(_tmp_1, 4);

	gtk_spin_button_set_range(this->spin_width, 1, maxwidth + 1);
	gtk_spin_button_set_increments(this->spin_width, 1, 16);
	gtk_spin_button_set_value(this->spin_width, DEFWIDTH_DOC);

	gtk_spin_button_set_range(this->spin_height, 1, maxwidth + 1);
	gtk_spin_button_set_increments(this->spin_height, 1, 16);
	gtk_spin_button_set_value(this->spin_height, DEFHEIGHT_DOC);

	gtk_widget_grab_focus((GtkWidget *) this->spin_width);
}

void new_doc_dialog_destruct(NewDocDialog *this)
{
	if(this->dlg) {
		gtk_widget_destroy((GtkWidget *) this->dlg);
	}
}

void new_doc_dialog_apply_preset(NewDocDialog *this, int w, int h)
{
	gtk_spin_button_set_value(this->spin_width, w);
	gtk_spin_button_set_value(this->spin_height, h);
}

_ngg_tuple_NewDocDialog__run new_doc_dialog_run(NewDocDialog *this)
{
	assert(this->dlg); /* newdocdialog.ngg:92 */

	int res = gtk_dialog_run(this->dlg);

	int w = 0;
	int h = w;
	_Bool ok = false;

	if(res == GTK_RESPONSE_ACCEPT) {
		w = (int) gtk_spin_button_get_value(this->spin_width);

		h = (int) gtk_spin_button_get_value(this->spin_height);

		assert(w > 0); /* newdocdialog.ngg:103 */

		assert(h > 0); /* newdocdialog.ngg:104 */

		if((w > this->maxwidth) || (h > this->maxwidth)) {
			printf("size overflow!\n");
		} else {
			ok = true;
		}
	}

	gtk_widget_set_visible((GtkWidget *) this->dlg, false);

	return (_ngg_tuple_NewDocDialog__run){ok, w, h};
}

void new_doc_dialog_on_btn_preset_clicked(GtkButton *widget, void *user_data)
{
	if(widget == ((NewDocDialog *) user_data)->btn_preset_fhd) {
		new_doc_dialog_apply_preset(((NewDocDialog *) user_data), 1920, 1080);
	} else if(widget == ((NewDocDialog *) user_data)->btn_preset_a4_150ppi) {
		new_doc_dialog_apply_preset(((NewDocDialog *) user_data), 1240, 1754);
	} else if(widget == ((NewDocDialog *) user_data)->btn_preset_a4_300ppi) {
		new_doc_dialog_apply_preset(((NewDocDialog *) user_data), 2480, 3508);
	} else {
		assert(false); /* newdocdialog.ngg:128 */
	}
}

void new_doc_dialog_on_btn_swap_clicked(GtkButton *widget, void *user_data)
{
	double wbak = gtk_spin_button_get_value(((NewDocDialog *) user_data)->spin_width);
	double _tmp_1 = gtk_spin_button_get_value(((NewDocDialog *) user_data)->spin_height);
	gtk_spin_button_set_value(((NewDocDialog *) user_data)->spin_width, _tmp_1);
	gtk_spin_button_set_value(((NewDocDialog *) user_data)->spin_height, wbak);
}

_ngg_tuple_NewDocDialog__run _ngg_tuple__new_doc_dialog__run_default()
{
	_ngg_tuple_NewDocDialog__run s;
	s.m0 = false;
	s.m1 = 0;
	s.m2 = 0;
	return s;
}
