/* pixel.h
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#ifndef N96_DRAW_pixel_h
#define N96_DRAW_pixel_h

typedef struct Pixel Pixel;
typedef struct LinearPixel LinearPixel;
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#define PIXSTRIDE (4)
struct Pixel {
	float rgb[PIXSTRIDE];
};

struct LinearPixel {
	float rgb[PIXSTRIDE];
};

Pixel pixel_default();
LinearPixel linear_pixel_default();
void linear_pixel_assert(LinearPixel pixel);
LinearPixel linear_rgbapixel_from_linear_rgbpixel(LinearPixel pixel, double a);
double linear2srgb(double clin);
double srgb2linear(double csrgb);
Pixel linearpixel2srgb(LinearPixel lpx);
LinearPixel srgbpixel2linear(Pixel spx);

#endif /* N96_DRAW_pixel_h */
