/* procedural.h
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#ifndef N96_DRAW_procedural_h
#define N96_DRAW_procedural_h

typedef struct InstructionOwningVector InstructionOwningVector;
typedef struct ProceduralContext ProceduralContext;
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "brushes.h"
#include "doc.h"
#include "inst.h"
struct InstructionOwningVector {
	Instruction **arr;
	int alloccount;
	int count;
};

struct ProceduralContext {
	InstructionOwningVector *iov;
	int counter;
	ImageDocument *doc;
};

void instruction_owning_vector_destruct(InstructionOwningVector *this);
void instruction_owning_vector__resize(InstructionOwningVector *this, int newcount);
void instruction_owning_vector_append(InstructionOwningVector *this, Instruction *newitem);
void instruction_owning_vector_clear(InstructionOwningVector *this);
void instruction_owning_vector_delete_all(InstructionOwningVector *this);
Instruction * instruction_owning_vector_get_item(InstructionOwningVector *this, int index);
Instruction * instruction_owning_vector_pop(InstructionOwningVector *this);
void instruction_owning_vector_set_item(InstructionOwningVector *this, int index, Instruction *itm);
int instruction_owning_vector_get_count(InstructionOwningVector *this);
_Bool instruction_owning_vector_is_empty(InstructionOwningVector *this);
void instruction_owning_vector_construct(InstructionOwningVector *this);
void procedural_context_execute_all(ProceduralContext *this);
_Bool procedural_context_execute_next(ProceduralContext *this);
void procedural_context_queue(ProceduralContext *this, Instruction *inst);
void procedural_context_construct(ProceduralContext *this, ImageDocument *doc);
void procedural_context_destruct(ProceduralContext *this);
void mchelper_draw_dot_perc_nongui(ImageDocument *doc, double x, double y, double pressure);
void mchelper_draw_line_perc_nongui(ImageDocument *doc, double x1, double y1, double p1, double x2, double y2, double p2);
void mchelper_set_fill_size_perc_nongui(ImageDocument *doc, double siz);
void mchelper_set_stroke_color_nongui(ImageDocument *doc, float r, float g, float b);
void mchelper_draw_vgradient_nongui(ImageDocument *doc, double yfrom, double yto, double stp, double rfac, double gfac, double bfac, double opacity, _Bool absolutergb);
void mchelper_pick_brush_tool_nongui(ImageDocument *doc);

#endif /* N96_DRAW_procedural_h */
