/* quickpalette.h
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#ifndef N96_DRAW_quickpalette_h
#define N96_DRAW_quickpalette_h

typedef struct _ngg_tuple_QuickPalette__get_linear_color_at _ngg_tuple_QuickPalette__get_linear_color_at;
typedef struct QuickPalette QuickPalette;
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "imageview.h"
#include "imageview.h"
#define NSHADES (12)
struct _ngg_tuple_QuickPalette__get_linear_color_at {
	LinearPixel m0;
	_Bool m1;
	_Bool m2;
};

struct QuickPalette {
	GtkDrawingArea *da;
	_ngg_vtab_t_ImageView _ngg_vtab_image_view;
	Image *img;
	cairo_surface_t *surf;
	_Bool autoresize;
	void (*oncolorset_callback)(QuickPalette *widget, LinearPixel eventcolor_linear, void *user_data);
	void *oncolorset_data;
	int curw;
	int curh;
	LinearPixel selclr;
	LinearPixel selclr_spectrum;
	_Bool firsttime;
};

void quick_palette_construct(QuickPalette *this);
void quick_palette_on_da_event(GtkWidget *widget, GdkEvent *event, void *user_data);
void quick_palette_on_da_sizeallocate(GtkDrawingArea *widget, GdkRectangle *nggevent_allocation, void *user_data);
void quick_palette_set_hexpand(QuickPalette *this, _Bool expand);
_ngg_tuple_QuickPalette__get_linear_color_at quick_palette_get_linear_color_at(QuickPalette *this, int x, int y, _Bool dragging);
void quick_palette__nggnonvirt_destruct(QuickPalette *this);
void fill_spectrum(Image *img, LinearPixel basecolor, _Bool redraw_spectrum);
_ngg_tuple_QuickPalette__get_linear_color_at _ngg_tuple__quick_palette__get_linear_color_at_default();

#endif /* N96_DRAW_quickpalette_h */
