/* test-nongui.c
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#include <assert.h>
#include <stdarg.h>
#include <stdbool.h>

#include "test-nongui.h"


void test_nongui_memleak_draw(int count)
{
	int i;
	printf("test memory leak: %d x draw in ImageDocument\n", count);
	ImageDocument *doc = (ImageDocument *) malloc(sizeof(ImageDocument));
	if(doc == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	image_document_construct(doc, 16, 16, default_drawparams(), true);
	for(i = 0; i < count; i += 1) {
		doc->drawparams.active_tool = TOOL_FLOODFILL;
		LinearPixel _tmp_1;
		if(i % 2) {
			_tmp_1 = LINEAR_PIXEL_BLACK;
		} else {
			_tmp_1 = LINEAR_PIXEL_RED;
		}

		doc->drawparams.fgcolor = _tmp_1;
		image_document_floodfill(doc, 0, 0);
	}

	if(doc) {
		image_document_destruct(doc);
		free(doc);
	}
}

void test_nongui_memleak_imgdoc(int count)
{
	int i;
	printf("test memory leak: %d x new ImageDocument\n", count);
	for(i = 0; i < count; i += 1) {
		ImageDocument *doc = (ImageDocument *) malloc(sizeof(ImageDocument));
		if(doc == NULL) {
			perror(NULL);
			exit(EXIT_FAILURE);
		}

		image_document_construct(doc, 2480, 3508, default_drawparams(), true);
		if(doc) {
			image_document_destruct(doc);
			free(doc);
		}
	}
}

void test_nongui_memleak_writexcf(int count)
{
	int i;
	printf("test memory leak: %d x write an xcf image\n", count);
	for(i = 0; i < count; i += 1) {
		ImageDocument *_ngg_tmp_0 = (ImageDocument *) malloc(sizeof(ImageDocument));
		if(_ngg_tmp_0 == NULL) {
			perror(NULL);
			exit(EXIT_FAILURE);
		}

		image_document_construct(_ngg_tmp_0, 64, 64, default_drawparams(), true);
		assert(0 == write_xcf_from_image_document("/tmp/vara-test-xcf-memleak.xcf", _ngg_tmp_0)); /* test-nongui.ngg:26 */
		if(_ngg_tmp_0) {
			image_document_destruct(_ngg_tmp_0);
			free(_ngg_tmp_0);
		}
	}
}

void test_nongui_layerops_bg_fg()
{
	printf("test ImageDocument (bg-fg): default layer status\n");

	ImageDocument *doc = (ImageDocument *) malloc(sizeof(ImageDocument));
	if(doc == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	image_document_construct(doc, 16, 16, default_drawparams(), true);
	assert(layer_owning_vector_get_count(doc->layers) == 2); /* test-nongui.ngg:36 */
	assert(intvector_get_count(doc->layerstack) == 2); /* test-nongui.ngg:37 */
	assert(doc->in_bg_fg_mode); /* test-nongui.ngg:38 */
	assert(image_document_get_bglayer_must(doc)); /* test-nongui.ngg:39 */
	assert(image_document_get_fglayer_must(doc)); /* test-nongui.ngg:40 */
	assert(image_document_get_curlayer(doc)); /* test-nongui.ngg:41 */

	assert(image_document_get_curlayer(doc) == image_document_get_fglayer_must(doc)); /* test-nongui.ngg:42 */

	printf("test ImageDocument (bg-fg): delete FG layer\n");

	assert(image_document_can_delete_layer(doc)); /* test-nongui.ngg:46 */
	image_document_delete_layer(doc);
	assert(layer_owning_vector_get_count(doc->layers) == 2); /* test-nongui.ngg:48 */
	assert(intvector_get_count(doc->layerstack) == 1); /* test-nongui.ngg:49 */
	assert(!doc->in_bg_fg_mode); /* test-nongui.ngg:50 */
	assert(image_document_get_bglayer_must(doc)); /* test-nongui.ngg:51 */
	assert(image_document_get_fglayer_must(doc)); /* test-nongui.ngg:52 */
	assert(image_document_get_curlayer(doc)); /* test-nongui.ngg:53 */
	assert(image_document_get_curlayer(doc) == image_document_get_bglayer_must(doc)); /* test-nongui.ngg:54 */
	assert(!image_document_can_delete_layer(doc)); /* test-nongui.ngg:55 */
	if(doc) {
		image_document_destruct(doc);
		free(doc);
	}
}

void test_nongui_layerops_non_bg_fg()
{
	printf("test ImageDocument (non-bg-fg): default layer status\n");

	ImageDocument *doc = (ImageDocument *) malloc(sizeof(ImageDocument));
	if(doc == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	image_document_construct(doc, 16, 16, default_drawparams(), false);
	assert(!doc->in_bg_fg_mode); /* test-nongui.ngg:62 */

	assert(!image_document_can_delete_layer(doc)); /* test-nongui.ngg:63 */

	printf("test ImageDocument (non-bg-fg): create layer\n");

	assert(image_document_can_create_layer(doc)); /* test-nongui.ngg:67 */
	image_document_create_layer(doc, "Layer 1", LINEAR_PIXEL_TRANSP);
	assert(layer_owning_vector_get_count(doc->layers) == 1); /* test-nongui.ngg:69 */
	assert(intvector_get_count(doc->layerstack) == 1); /* test-nongui.ngg:70 */
	assert(!doc->in_bg_fg_mode); /* test-nongui.ngg:71 */

	assert(!image_document_can_delete_layer(doc)); /* test-nongui.ngg:72 */

	assert(image_document_can_create_layer(doc)); /* test-nongui.ngg:74 */
	image_document_create_layer(doc, "Layer 2", LINEAR_PIXEL_TRANSP);
	assert(layer_owning_vector_get_count(doc->layers) == 2); /* test-nongui.ngg:76 */
	assert(intvector_get_count(doc->layerstack) == 2); /* test-nongui.ngg:77 */
	assert(!doc->in_bg_fg_mode); /* test-nongui.ngg:78 */
	assert(image_document_can_delete_layer(doc)); /* test-nongui.ngg:79 */
	if(doc) {
		image_document_destruct(doc);
		free(doc);
	}
}

int testmain_nongui(int count)
{
	test_nongui_memleak_imgdoc(count);
	test_nongui_memleak_draw(count);
	test_nongui_memleak_writexcf(count);
	test_nongui_layerops_bg_fg();

	test_nongui_layerops_non_bg_fg();

	return 0;
}
