/* test.h
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#ifndef N96_DRAW_test_h
#define N96_DRAW_test_h

typedef struct thread thread;
typedef struct thread_mutex thread_mutex;
typedef struct ProceduralGuiTestingContext ProceduralGuiTestingContext;
typedef struct ExmcmxArgs ExmcmxArgs;
typedef struct GuiTestingContext GuiTestingContext;
typedef struct TestStrokeContext TestStrokeContext;
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "procedural.h"
#include "ui.h"
#include <unistd.h>
#include <math.h>
struct thread {
	pthread_t tid;
};

struct thread_mutex {
	pthread_mutex_t *mutex;
};

void * thread_worker(void *usrdata);
struct ProceduralGuiTestingContext {
	myapp *app;
	ProceduralContext *pctx;
};

struct ExmcmxArgs {
	void *fnc;
	GuiTestingContext *tctx;
};

struct GuiTestingContext {
	thread_mutex *mx;
	myapp *app;
};

struct TestStrokeContext {
	int stp;
	thread_mutex *mx;
	myapp *app;
	int maxstp;
	int xoffset;
};

void thread_destruct(thread *this);
void thread_construct(thread *this);
pthread_mutex_t * new_pthread_mutex_t_must();
void thread_mutex_construct(thread_mutex *this);
void thread_mutex_destruct(thread_mutex *this);
thread * thread_start(void * (*twfun)(void *usrdata), void *usrdata);
thread * thread_start_or_serial(void * (*twfun)(void *usrdata), void *usrdata);
void thread_join(thread *thandle);
void thread_mutex_lock(thread_mutex *thandle);
void thread_mutex_trylock(thread_mutex *thandle);
void thread_mutex_unlock(thread_mutex *thandle);
int thread_cancel(thread *thandle);
void procedural_gui_testing_context_construct(ProceduralGuiTestingContext *this, myapp *app, ProceduralContext *pctx);
void procedural_gui_testing_context_destruct(ProceduralGuiTestingContext *this);
void animate_procedural_context(ProceduralGuiTestingContext *tctx, int interval);
_Bool on_gui_testing_context_tick(ProceduralGuiTestingContext *tctx);
void exmcmx_args_construct(ExmcmxArgs *this, void *fnc, GuiTestingContext *tctx);
void exmcmx_args_destruct(ExmcmxArgs *this);
_Bool mchelper_exmcmx(ExmcmxArgs *args);
void gui_testing_context_exmcmx(GuiTestingContext *this, void *fnc);
void gui_testing_context_construct(GuiTestingContext *this, myapp *app);
void gui_testing_context_destruct(GuiTestingContext *this);
void uidelay();
void uidelay_minimal();
int helper_select_next_prebrush(GuiTestingContext *tctx, int i);
_Bool mctest_increase_fill_size(myapp *app);
_Bool mctest_layerops_0(myapp *app);
_Bool mctest_layerops_10(myapp *app);
_Bool mctest_layerops_20(myapp *app);
_Bool mctest_layerops_30(myapp *app);
_Bool mctest_select_ballpoint_brush(myapp *app);
_Bool mctest_select_brush_tool(myapp *app);
_Bool mctest_select_charcoal_brush(myapp *app);
_Bool mctest_select_cryaon_brush(myapp *app);
_Bool mctest_select_floodfill_tool(myapp *app);
_Bool mctest_select_pencil_brush(myapp *app);
_Bool mctest_select_round_brush(myapp *app);
_Bool mctest_select_randsquare_brush_type(myapp *app);
_Bool mctest_select_round_pressure_size_brush(myapp *app);
_Bool mctest_select_soft_round_brush(myapp *app);
_Bool mctest_assert_round_brush(myapp *app);
_Bool mctest_zoom_in(myapp *app);
_Bool mctest_zoom_out(myapp *app);
void test_stroke_context_construct(TestStrokeContext *this, myapp *app, int maxstp, int xoffset);
void test_stroke_context_destruct(TestStrokeContext *this);
_Bool mctest_draw(TestStrokeContext *ctx);
void test_draw(myapp *app, int xoffset, _Bool animate);
void mchelper_draw_dot_perc(myapp *app, double x, double y, double pressure);
void mchelper_draw_line_perc(myapp *app, double x1, double y1, double p1, double x2, double y2, double p2);
int mchelper_list_box_count(GtkListBox *lst);
void mchelper_test_active_layer_name(const char * expected, myapp *app);
void mchelper_test_bg_fg_mode(_Bool expected, myapp *app);
void mchelper_set_fill_size_perc(myapp *app, double siz);
void mchelper_set_stroke_color(myapp *app, float r, float g, float b);
void mctest_draw_sunset(ProceduralGuiTestingContext *tctx);
void mctest_draw_vara_logo(ImageDocument *doc, int iconsiz);
void test_basic_drawing(GuiTestingContext *tctx);
void test_brushes(GuiTestingContext *tctx);
void test_layerops(GuiTestingContext *tctx);
int test_next_xoffset(int xoffset, myapp *app);
void test_nocrash_brushes_while_floodfill(GuiTestingContext *tctx);
void testmain_general(myapp *app);
void testmain_draw_vara_logo(myapp *app);
ProceduralGuiTestingContext * testmain_sunset(myapp *app);
void tw_testmain_general(myapp *app);

#endif /* N96_DRAW_test_h */
