/* ui-icons.h
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#ifndef N96_DRAW_ui_icons_h
#define N96_DRAW_ui_icons_h

typedef struct ToolIcons ToolIcons;
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "defaults.h"
#include "doc.h"
struct ToolIcons {
	Image *img_pencil;
	Image *img_brush;
	Image *img_eraser;
	Image *img_eyedropper;
	Image *img_floodfill;
	Image *img_pan;
};

void tool_icons_destruct(ToolIcons *this);
void tool_icons_construct(ToolIcons *this);
void helper_draw_line_perc(ImageDocument *doc, double x1, double y1, double p1, double x2, double y2, double p2);
void helper_set_fill_size_perc(ImageDocument *doc, double siz);
void helper_set_stroke_color(ImageDocument *doc, float r, float g, float b);
ToolIcons * draw_icons();

#endif /* N96_DRAW_ui_icons_h */
