/* ui.c
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#include <assert.h>
#include <stdarg.h>
#include <stdbool.h>

#include "ui.h"


#include "warpcore.c"

CommandLineOptions clopts;

double ZOOMSTEP = 0.1;

SimpleHelpItem helpitems[2] = {(SimpleHelpItem) { "Wipe vs Clear", "Clear simply deletes whatever is on the active layer and makes all pixels transparent. Wipe does the same for the foreground layer, but it sets all pixels to white instead of transparent for the background layer. Both options are available in the Edit menu, but only Wipe is given in the toolbar because that is the behaviour most beginners might expect." }, (SimpleHelpItem) { "Scratchpad mode", "Scratchpad mode turns the current document into a sandbox, letting you try brushes and colours directly on the main canvas without making permanent changes. All the changes made in this mode are automatically undone when you exit the mode. Certain features like undo/redo and layer switching are disabled. A yellow-black caution tape is drawn around the canvas to let you know you are in scratchpad mode." }};

void myapp_construct(myapp *this, const char * infile_path)
{
	size_t _ngg_tmp_4;
	const char * beng;
	size_t _ngg_tmp_3;
	SimpleHelpItem helpitem;
	ImageDocument *_tmp_1 = (ImageDocument *) malloc(sizeof(ImageDocument));
	if(_tmp_1 == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	image_document_construct(_tmp_1, DEFWIDTH_DOC, DEFHEIGHT_DOC, default_drawparams(), true);
	this->doc = _tmp_1;
	this->wnd = (GtkWindow *) gtk_window_new(GTK_WINDOW_TOPLEVEL);
	this->accgrp = (GtkAccelGroup *) gtk_accel_group_new();
	GtkBox *_ngg_tmp_31;
	GtkBox *bx = (GtkBox *) gtk_box_new(GTK_ORIENTATION_VERTICAL, 4);
	gtk_container_set_border_width((GtkContainer *) bx, (unsigned int) 4);
	_ngg_tmp_31 = bx;
	this->box_main = _ngg_tmp_31;
	this->mbr = (GtkMenuBar *) gtk_menu_bar_new();
	this->mni_file = (GtkMenuItem *) gtk_menu_item_new();
	this->mnu_file = (GtkMenu *) gtk_menu_new();
	this->mni_file_new = (GtkMenuItem *) gtk_menu_item_new();
	this->mni_file_open = (GtkMenuItem *) gtk_menu_item_new();
	this->mnisep_file_1 = (GtkSeparatorMenuItem *) gtk_separator_menu_item_new();
	this->mni_file_save_as = (GtkMenuItem *) gtk_menu_item_new();
	this->mnisep_file_2 = (GtkSeparatorMenuItem *) gtk_separator_menu_item_new();
	this->mni_file_export = (GtkMenuItem *) gtk_menu_item_new();
	this->mni_file_export_layer = (GtkMenuItem *) gtk_menu_item_new();
	this->mnisep_file_3 = (GtkSeparatorMenuItem *) gtk_separator_menu_item_new();
	this->mni_file_quit = (GtkMenuItem *) gtk_menu_item_new();
	this->mni_edit = (GtkMenuItem *) gtk_menu_item_new();
	this->mnu_edit = (GtkMenu *) gtk_menu_new();
	this->mni_edit_undo = (GtkMenuItem *) gtk_menu_item_new();
	this->mni_edit_redo = (GtkMenuItem *) gtk_menu_item_new();
	this->mnisep_edit_1 = (GtkSeparatorMenuItem *) gtk_separator_menu_item_new();
	this->mni_edit_fill_fgcolor = (GtkMenuItem *) gtk_menu_item_new();
	this->mni_edit_fill_bgcolor = (GtkMenuItem *) gtk_menu_item_new();
	this->mni_edit_clear = (GtkMenuItem *) gtk_menu_item_new();
	this->mni_view = (GtkMenuItem *) gtk_menu_item_new();
	this->mnu_view = (GtkMenu *) gtk_menu_new();
	this->mni_view_zoomin = (GtkMenuItem *) gtk_menu_item_new();
	this->mni_view_zoomout = (GtkMenuItem *) gtk_menu_item_new();
	this->mni_view_zoom100 = (GtkMenuItem *) gtk_menu_item_new();
	this->mni_view_zoomfit = (GtkMenuItem *) gtk_menu_item_new();
	this->mnisep_view_1 = (GtkSeparatorMenuItem *) gtk_separator_menu_item_new();
	this->mni_view_layers = (GtkMenuItem *) gtk_menu_item_new();
	this->mni_tools = (GtkMenuItem *) gtk_menu_item_new();
	this->mnu_tools = (GtkMenu *) gtk_menu_new();
	this->mni_tools_pencil = (GtkMenuItem *) gtk_menu_item_new();
	this->mni_tools_brush = (GtkMenuItem *) gtk_menu_item_new();
	this->mni_tools_eraser = (GtkMenuItem *) gtk_menu_item_new();
	this->mni_tools_floodfill = (GtkMenuItem *) gtk_menu_item_new();
	this->mni_tools_eyedropper = (GtkMenuItem *) gtk_menu_item_new();
	this->mni_tools_pan = (GtkMenuItem *) gtk_menu_item_new();
	this->mni_tools_bplus = (GtkMenuItem *) gtk_menu_item_new();
	this->mni_tools_bminus = (GtkMenuItem *) gtk_menu_item_new();
	this->mni_help = (GtkMenuItem *) gtk_menu_item_new();
	this->mnu_help = (GtkMenu *) gtk_menu_new();
	this->mni_help_topics = (GtkMenuItem *) gtk_menu_item_new();
	this->mni_help_about = (GtkMenuItem *) gtk_menu_item_new();
	GtkBox *_ngg_tmp_32;
	GtkBox *_ngg_tmp_34_bx = (GtkBox *) gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 4);
	gtk_container_set_border_width((GtkContainer *) _ngg_tmp_34_bx, (unsigned int) 4);
	_ngg_tmp_32 = _ngg_tmp_34_bx;
	this->box_controls2 = _ngg_tmp_32;
	this->fme_tools = (GtkFrame *) gtk_frame_new("");
	GtkBox *_ngg_tmp_35;
	GtkBox *_ngg_tmp_37_bx = (GtkBox *) gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 4);
	gtk_container_set_border_width((GtkContainer *) _ngg_tmp_37_bx, (unsigned int) 4);
	_ngg_tmp_35 = _ngg_tmp_37_bx;
	this->box_tools = _ngg_tmp_35;
	this->btn_pencil = (GtkRadioButton *) gtk_radio_button_new(NULL);
	this->btn_brush = (GtkRadioButton *) gtk_radio_button_new(NULL);
	this->btn_eraser = (GtkRadioButton *) gtk_radio_button_new(NULL);
	this->btn_eyedropper = (GtkRadioButton *) gtk_radio_button_new(NULL);
	this->btn_floodfill = (GtkRadioButton *) gtk_radio_button_new(NULL);
	this->btn_pan = (GtkRadioButton *) gtk_radio_button_new(NULL);
	this->fme_color = (GtkFrame *) gtk_frame_new("");
	GtkBox *_ngg_tmp_38;
	GtkBox *_ngg_tmp_40_bx = (GtkBox *) gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 4);
	gtk_container_set_border_width((GtkContainer *) _ngg_tmp_40_bx, (unsigned int) 4);
	_ngg_tmp_38 = _ngg_tmp_40_bx;
	this->box_color = _ngg_tmp_38;
	this->btn_color = (GtkColorButton *) gtk_color_button_new();
	this->fme_brushsiz = (GtkFrame *) gtk_frame_new("");
	this->spn_brushsiz = (GtkSpinButton *) gtk_spin_button_new(NULL, 0.1, 2u);
	this->fme_brushpreview = (GtkFrame *) gtk_frame_new("");
	ImageView *_tmp_2 = (ImageView *) malloc(sizeof(ImageView));
	if(_tmp_2 == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	image_view_construct(_tmp_2);
	this->iv_brushpreview = _tmp_2;
	this->fme_brushes = (GtkFrame *) gtk_frame_new("");
	GtkBox *_ngg_tmp_41;
	GtkBox *_ngg_tmp_43_bx = (GtkBox *) gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 4);
	gtk_container_set_border_width((GtkContainer *) _ngg_tmp_43_bx, (unsigned int) 4);
	_ngg_tmp_41 = _ngg_tmp_43_bx;
	this->box_brushes = _ngg_tmp_41;
	this->btn_prebrush_ballpoint = (GtkButton *) gtk_button_new();
	this->btn_prebrush_pencil = (GtkButton *) gtk_button_new();
	this->btn_prebrush_crayon = (GtkButton *) gtk_button_new();
	this->btn_prebrush_charcoal = (GtkButton *) gtk_button_new();
	this->btn_prebrush_round = (GtkButton *) gtk_button_new();
	this->btn_prebrush_round_pressure_size = (GtkButton *) gtk_button_new();
	this->btn_prebrush_soft_round = (GtkButton *) gtk_button_new();
	this->fme_advanced = (GtkFrame *) gtk_frame_new("");
	GtkBox *_ngg_tmp_44;
	GtkBox *_ngg_tmp_46_bx = (GtkBox *) gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 4);
	gtk_container_set_border_width((GtkContainer *) _ngg_tmp_46_bx, (unsigned int) 4);
	_ngg_tmp_44 = _ngg_tmp_46_bx;
	this->box_advanced = _ngg_tmp_44;
	this->chk_scratch = (GtkCheckButton *) gtk_check_button_new();
	this->chk_advanced = (GtkCheckButton *) gtk_check_button_new();
	this->fme_history = (GtkFrame *) gtk_frame_new("");
	GtkBox *_ngg_tmp_47;
	GtkBox *_ngg_tmp_49_bx = (GtkBox *) gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 4);
	gtk_container_set_border_width((GtkContainer *) _ngg_tmp_49_bx, (unsigned int) 4);
	_ngg_tmp_47 = _ngg_tmp_49_bx;
	this->box_history = _ngg_tmp_47;
	this->btn_undo = (GtkButton *) gtk_button_new();
	this->btn_redo = (GtkButton *) gtk_button_new();
	this->grd_viewport = (GtkGrid *) gtk_grid_new();
	this->da = (GtkDrawingArea *) gtk_drawing_area_new();
	this->vscroll = (GtkScrollbar *) gtk_scrollbar_new(GTK_ORIENTATION_VERTICAL, NULL);
	this->hscroll = (GtkScrollbar *) gtk_scrollbar_new(GTK_ORIENTATION_HORIZONTAL, NULL);
	this->nbk_advanced = (GtkNotebook *) gtk_notebook_new();
	this->grd_bottom = (GtkGrid *) gtk_grid_new();
	GtkBox *_ngg_tmp_50;
	GtkBox *_ngg_tmp_52_bx = (GtkBox *) gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 4);
	gtk_container_set_border_width((GtkContainer *) _ngg_tmp_52_bx, (unsigned int) 4);
	_ngg_tmp_50 = _ngg_tmp_52_bx;
	this->box_newdoc = _ngg_tmp_50;
	this->fme_newdoc = (GtkFrame *) gtk_frame_new("");
	GtkBox *_ngg_tmp_53;
	GtkBox *_ngg_tmp_55_bx = (GtkBox *) gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 4);
	gtk_container_set_border_width((GtkContainer *) _ngg_tmp_55_bx, (unsigned int) 4);
	_ngg_tmp_53 = _ngg_tmp_55_bx;
	this->hbx_newdoc = _ngg_tmp_53;
	this->btn_export_doc = (GtkButton *) gtk_button_new();
	GtkBox *_ngg_tmp_56;
	GtkBox *_ngg_tmp_58_bx = (GtkBox *) gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 4);
	gtk_container_set_border_width((GtkContainer *) _ngg_tmp_58_bx, (unsigned int) 4);
	_ngg_tmp_56 = _ngg_tmp_58_bx;
	this->box_controls1 = _ngg_tmp_56;
	this->fme_quicklayers = (GtkFrame *) gtk_frame_new("");
	GtkBox *_ngg_tmp_59;
	GtkBox *_ngg_tmp_61_bx = (GtkBox *) gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 4);
	gtk_container_set_border_width((GtkContainer *) _ngg_tmp_61_bx, (unsigned int) 4);
	_ngg_tmp_59 = _ngg_tmp_61_bx;
	this->box_quicklayers = _ngg_tmp_59;
	this->btn_fglayer = (GtkRadioButton *) gtk_radio_button_new(NULL);
	this->btn_bglayer = (GtkRadioButton *) gtk_radio_button_new(NULL);
	this->btn_more_layers = (GtkButton *) gtk_button_new();
	this->fme_layer_visibility = (GtkFrame *) gtk_frame_new("");
	GtkBox *_ngg_tmp_62;
	GtkBox *_ngg_tmp_64_bx = (GtkBox *) gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 4);
	gtk_container_set_border_width((GtkContainer *) _ngg_tmp_64_bx, (unsigned int) 4);
	_ngg_tmp_62 = _ngg_tmp_64_bx;
	this->box_layer_visibility = _ngg_tmp_62;
	this->chk_fg_visible = (GtkCheckButton *) gtk_check_button_new();
	this->chk_bg_visible = (GtkCheckButton *) gtk_check_button_new();
	this->fme_layeracts = (GtkFrame *) gtk_frame_new("");
	GtkBox *_ngg_tmp_65;
	GtkBox *_ngg_tmp_67_bx = (GtkBox *) gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 4);
	gtk_container_set_border_width((GtkContainer *) _ngg_tmp_67_bx, (unsigned int) 4);
	_ngg_tmp_65 = _ngg_tmp_67_bx;
	this->box_layeracts = _ngg_tmp_65;
	this->btn_layer_fillbgcolor = (GtkButton *) gtk_button_new();
	QuickPalette *_tmp_3 = (QuickPalette *) malloc(sizeof(QuickPalette));
	if(_tmp_3 == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	quick_palette_construct(_tmp_3);
	this->quickpalette = _tmp_3;
	this->fme_zoom = (GtkFrame *) gtk_frame_new("");
	this->tbr_zoom = (GtkToolbar *) gtk_toolbar_new();
	this->btn_center = (GtkToolButton *) gtk_tool_button_new(NULL, NULL);
	this->btn_zoom100 = (GtkToolButton *) gtk_tool_button_new(NULL, NULL);
	this->btn_zoomout = (GtkToolButton *) gtk_tool_button_new(NULL, NULL);
	this->btn_zoomin = (GtkToolButton *) gtk_tool_button_new(NULL, NULL);
	this->tbi_lbl_zoom = (GtkToolItem *) gtk_tool_item_new();
	this->lbl_zoom = (GtkLabel *) gtk_label_new(NULL);
	GtkBox *_ngg_tmp_68;
	GtkBox *_ngg_tmp_70_bx = (GtkBox *) gtk_box_new(GTK_ORIENTATION_VERTICAL, 4);
	gtk_container_set_border_width((GtkContainer *) _ngg_tmp_70_bx, (unsigned int) 4);
	_ngg_tmp_68 = _ngg_tmp_70_bx;
	this->box_brushopts = _ngg_tmp_68;
		this->cbo_brush_engine = (GtkComboBoxText *) (gtk_combo_box_text_new());
	this->chk_pressure = (GtkCheckButton *) gtk_check_button_new();
	EntrySlider *_tmp_4 = (EntrySlider *) malloc(sizeof(EntrySlider));
	if(_tmp_4 == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	entry_slider_construct(_tmp_4);
	this->sldr_brush_opacity = _tmp_4;
	EntrySlider *_tmp_5 = (EntrySlider *) malloc(sizeof(EntrySlider));
	if(_tmp_5 == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	entry_slider_construct(_tmp_5);
	this->sldr_brush_softness = _tmp_5;
	EntrySlider *_tmp_6 = (EntrySlider *) malloc(sizeof(EntrySlider));
	if(_tmp_6 == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	entry_slider_construct(_tmp_6);
	this->sldr_brush_aaradius_circle1 = _tmp_6;
	GtkBox *_ngg_tmp_71;
	GtkBox *_ngg_tmp_73_bx = (GtkBox *) gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 4);
	gtk_container_set_border_width((GtkContainer *) _ngg_tmp_73_bx, (unsigned int) 4);
	_ngg_tmp_71 = _ngg_tmp_73_bx;
	this->hbx_scatter_type = _ngg_tmp_71;
	this->lbl_scatter_type = (GtkLabel *) gtk_label_new(NULL);
	this->rad_scatter_type_none = (GtkRadioButton *) gtk_radio_button_new(NULL);
	this->rad_scatter_type_circle = (GtkRadioButton *) gtk_radio_button_new(NULL);
	this->rad_scatter_type_square = (GtkRadioButton *) gtk_radio_button_new(NULL);
	EntrySlider *_tmp_7 = (EntrySlider *) malloc(sizeof(EntrySlider));
	if(_tmp_7 == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	entry_slider_construct(_tmp_7);
	this->sldr_brush_scatter_radius = _tmp_7;
	EntrySlider *_tmp_8 = (EntrySlider *) malloc(sizeof(EntrySlider));
	if(_tmp_8 == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	entry_slider_construct(_tmp_8);
	this->sldr_brush_scatter_density = _tmp_8;
	this->chk_scatter_take_pressure = (GtkCheckButton *) gtk_check_button_new();
	GtkBox *_ngg_tmp_74;
	GtkBox *_ngg_tmp_76_bx = (GtkBox *) gtk_box_new(GTK_ORIENTATION_VERTICAL, 4);
	gtk_container_set_border_width((GtkContainer *) _ngg_tmp_76_bx, (unsigned int) 4);
	_ngg_tmp_74 = _ngg_tmp_76_bx;
	this->box_strokeopts = _ngg_tmp_74;
	EntrySlider *_tmp_9 = (EntrySlider *) malloc(sizeof(EntrySlider));
	if(_tmp_9 == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	entry_slider_construct(_tmp_9);
	this->sldr_stroke_smoothness = _tmp_9;
	this->chk_subpixel_when_zoomed = (GtkCheckButton *) gtk_check_button_new();
	GtkBox *_ngg_tmp_77;
	GtkBox *_ngg_tmp_79_bx = (GtkBox *) gtk_box_new(GTK_ORIENTATION_VERTICAL, 4);
	gtk_container_set_border_width((GtkContainer *) _ngg_tmp_79_bx, (unsigned int) 4);
	_ngg_tmp_77 = _ngg_tmp_79_bx;
	this->box_coloropts = _ngg_tmp_77;
	EntrySlider *_tmp_10 = (EntrySlider *) malloc(sizeof(EntrySlider));
	if(_tmp_10 == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	entry_slider_construct(_tmp_10);
	this->sldr_color_hue = _tmp_10;
	EntrySlider *_tmp_11 = (EntrySlider *) malloc(sizeof(EntrySlider));
	if(_tmp_11 == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	entry_slider_construct(_tmp_11);
	this->sldr_color_sat = _tmp_11;
	EntrySlider *_tmp_12 = (EntrySlider *) malloc(sizeof(EntrySlider));
	if(_tmp_12 == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	entry_slider_construct(_tmp_12);
	this->sldr_color_lit = _tmp_12;
	GtkBox *_ngg_tmp_80;
	GtkBox *_ngg_tmp_82_bx = (GtkBox *) gtk_box_new(GTK_ORIENTATION_VERTICAL, 4);
	gtk_container_set_border_width((GtkContainer *) _ngg_tmp_82_bx, (unsigned int) 4);
	_ngg_tmp_80 = _ngg_tmp_82_bx;
	this->box_layers = _ngg_tmp_80;
	this->tbr_layers = (GtkToolbar *) gtk_toolbar_new();
	this->btn_layer_new = (GtkToolButton *) gtk_tool_button_new(NULL, NULL);
	this->btn_layer_move_up = (GtkToolButton *) gtk_tool_button_new(NULL, NULL);
	this->btn_layer_move_down = (GtkToolButton *) gtk_tool_button_new(NULL, NULL);
	this->btn_layer_rename = (GtkToolButton *) gtk_tool_button_new(NULL, NULL);
	this->btn_layer_delete = (GtkToolButton *) gtk_tool_button_new(NULL, NULL);
	this->sw_layers = (GtkScrolledWindow *) gtk_scrolled_window_new(NULL, NULL);
	this->lst_layers = (GtkListBox *) gtk_list_box_new();
	EntrySlider *_tmp_13 = (EntrySlider *) malloc(sizeof(EntrySlider));
	if(_tmp_13 == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	entry_slider_construct(_tmp_13);
	this->sldr_layer_opacity = _tmp_13;
	this->updating_lst_layers = false;
	this->layerstack_version = 0;
	this->color_being_set_by_hsl = false;
	this->test_vara_logo_exit = false;
	this->test_vara_logo_size = 0;
	this->curcursor_is_circle = false;
	this->curcursorsiz = 0;
	this->disable_brush_preview = false;
	this->was_autoscroll = false;
	this->surf = cairo_image_surface_create(CAIRO_FORMAT_RGB24, DEFWIDTH_DOC, DEFHEIGHT_DOC);

	DrawingParams dpbak = this->doc->drawparams;

	this->ivw_ballpoint = brushpreview_widget_new(prebrush_ballpoint());
	this->ivw_charcoal = brushpreview_widget_new(prebrush_charcoal());
	this->ivw_crayon = brushpreview_widget_new(prebrush_crayon());
	this->ivw_pencil = brushpreview_widget_new(prebrush_pencil());
	this->ivw_round = brushpreview_widget_new(prebrush_round());
	this->ivw_round_pressure_size = brushpreview_widget_new(prebrush_round_pressure_size());
	this->ivw_soft_round = brushpreview_widget_new(prebrush_soft_round());

	gtk_window_set_title(this->wnd, PROGRAM_NAME);
	g_signal_connect((GtkWidget *) this->wnd, "delete-event", G_CALLBACK(on_wnd_deleteevent), this);
	gtk_widget_set_visible((GtkWidget *) this->wnd, false);
	g_signal_connect((GtkWidget *) this->wnd, "destroy", G_CALLBACK(gtk_main_quit), NULL);
	gtk_window_add_accel_group(this->wnd, this->accgrp);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->wnd), GTK_WIDGET((GtkWidget *) this->box_main));
	gtk_box_set_spacing(this->box_main, 0);
	gtk_container_set_border_width((GtkContainer *) this->box_main, (unsigned int) 0);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_main), GTK_WIDGET((GtkWidget *) this->mbr));
	gtk_menu_shell_append((GtkMenuShell *) this->mbr, (GtkWidget *) this->mni_file);
	gtk_menu_item_set_label(this->mni_file, "_File");
	gtk_menu_item_set_use_underline(this->mni_file, true);
	gtk_menu_item_set_submenu(this->mni_file, (GtkWidget *) this->mnu_file);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_file, (GtkWidget *) this->mni_file_new);
	gtk_menu_item_set_label(this->mni_file_new, "_New...");
	gtk_menu_item_set_use_underline(this->mni_file_new, true);
	g_signal_connect((GtkWidget *) this->mni_file_new, "activate", G_CALLBACK(myapp_on_btn_new_doc_clicked), this);
	gtk_widget_show((GtkWidget *) this->mni_file_new);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_file, (GtkWidget *) this->mni_file_open);
	gtk_menu_item_set_label(this->mni_file_open, "_Open...");
	gtk_menu_item_set_use_underline(this->mni_file_open, true);
	g_signal_connect((GtkWidget *) this->mni_file_open, "activate", G_CALLBACK(myapp_on_mni_file_open_activate), this);
	gtk_widget_show((GtkWidget *) this->mni_file_open);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_file, (GtkWidget *) this->mnisep_file_1);
	gtk_widget_show((GtkWidget *) this->mnisep_file_1);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_file, (GtkWidget *) this->mni_file_save_as);
	gtk_menu_item_set_label(this->mni_file_save_as, "Save _As...");
	gtk_menu_item_set_use_underline(this->mni_file_save_as, true);
	g_signal_connect((GtkWidget *) this->mni_file_save_as, "activate", G_CALLBACK(myapp_on_mni_file_save_as_activate), this);
	gtk_widget_show((GtkWidget *) this->mni_file_save_as);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_file, (GtkWidget *) this->mnisep_file_2);
	gtk_widget_show((GtkWidget *) this->mnisep_file_2);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_file, (GtkWidget *) this->mni_file_export);
	gtk_menu_item_set_label(this->mni_file_export, "_Export...");
	gtk_menu_item_set_use_underline(this->mni_file_export, true);
	g_signal_connect((GtkWidget *) this->mni_file_export, "activate", G_CALLBACK(myapp_on_btn_export_doc_clicked), this);
	gtk_widget_show((GtkWidget *) this->mni_file_export);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_file, (GtkWidget *) this->mni_file_export_layer);
	gtk_menu_item_set_label(this->mni_file_export_layer, "Export _Layer...");
	gtk_menu_item_set_use_underline(this->mni_file_export_layer, true);
	g_signal_connect((GtkWidget *) this->mni_file_export_layer, "activate", G_CALLBACK(myapp_on_btn_export_layer_clicked), this);
	gtk_widget_show((GtkWidget *) this->mni_file_export_layer);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_file, (GtkWidget *) this->mnisep_file_3);
	gtk_widget_show((GtkWidget *) this->mnisep_file_3);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_file, (GtkWidget *) this->mni_file_quit);
	gtk_menu_item_set_label(this->mni_file_quit, "_Quit");
	gtk_menu_item_set_use_underline(this->mni_file_quit, true);
	g_signal_connect((GtkWidget *) this->mni_file_quit, "activate", G_CALLBACK(myapp_on_mni_file_quit_activate), this);
	gtk_widget_show((GtkWidget *) this->mni_file_quit);
	gtk_widget_show((GtkWidget *) this->mnu_file);
	gtk_widget_show((GtkWidget *) this->mni_file);
	gtk_menu_shell_append((GtkMenuShell *) this->mbr, (GtkWidget *) this->mni_edit);
	gtk_menu_item_set_label(this->mni_edit, "_Edit");
	gtk_menu_item_set_use_underline(this->mni_edit, true);
	gtk_menu_item_set_submenu(this->mni_edit, (GtkWidget *) this->mnu_edit);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_edit, (GtkWidget *) this->mni_edit_undo);
	gtk_menu_item_set_label(this->mni_edit_undo, "_Undo");
	gtk_menu_item_set_use_underline(this->mni_edit_undo, true);
	g_signal_connect((GtkWidget *) this->mni_edit_undo, "activate", G_CALLBACK(myapp_on_btn_undo_clicked), this);
	gtk_widget_show((GtkWidget *) this->mni_edit_undo);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_edit, (GtkWidget *) this->mni_edit_redo);
	gtk_menu_item_set_label(this->mni_edit_redo, "_Redo");
	gtk_menu_item_set_use_underline(this->mni_edit_redo, true);
	g_signal_connect((GtkWidget *) this->mni_edit_redo, "activate", G_CALLBACK(myapp_on_btn_redo_clicked), this);
	gtk_widget_show((GtkWidget *) this->mni_edit_redo);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_edit, (GtkWidget *) this->mnisep_edit_1);
	gtk_widget_show((GtkWidget *) this->mnisep_edit_1);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_edit, (GtkWidget *) this->mni_edit_fill_fgcolor);
	gtk_menu_item_set_label(this->mni_edit_fill_fgcolor, "_Fill with FG Colour");
	gtk_menu_item_set_use_underline(this->mni_edit_fill_fgcolor, true);
	g_signal_connect((GtkWidget *) this->mni_edit_fill_fgcolor, "activate", G_CALLBACK(myapp_on_mni_fill_fgcolor_activate), this);
	gtk_widget_show((GtkWidget *) this->mni_edit_fill_fgcolor);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_edit, (GtkWidget *) this->mni_edit_fill_bgcolor);
	gtk_menu_item_set_label(this->mni_edit_fill_bgcolor, "Fill with Layer _BG (Wipe)");
	gtk_menu_item_set_use_underline(this->mni_edit_fill_bgcolor, true);
	g_signal_connect((GtkWidget *) this->mni_edit_fill_bgcolor, "activate", G_CALLBACK(myapp_on_mni_fill_bgcolor_activate), this);
	gtk_widget_show((GtkWidget *) this->mni_edit_fill_bgcolor);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_edit, (GtkWidget *) this->mni_edit_clear);
	gtk_menu_item_set_label(this->mni_edit_clear, "_Clear");
	gtk_menu_item_set_use_underline(this->mni_edit_clear, true);
	g_signal_connect((GtkWidget *) this->mni_edit_clear, "activate", G_CALLBACK(myapp_on_btn_clear_layer_clicked), this);
	gtk_widget_show((GtkWidget *) this->mni_edit_clear);
	gtk_widget_show((GtkWidget *) this->mnu_edit);
	gtk_widget_show((GtkWidget *) this->mni_edit);
	gtk_menu_shell_append((GtkMenuShell *) this->mbr, (GtkWidget *) this->mni_view);
	gtk_menu_item_set_label(this->mni_view, "_View");
	gtk_menu_item_set_use_underline(this->mni_view, true);
	gtk_menu_item_set_submenu(this->mni_view, (GtkWidget *) this->mnu_view);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_view, (GtkWidget *) this->mni_view_zoomin);
	gtk_menu_item_set_label(this->mni_view_zoomin, "Zoom _In");
	gtk_menu_item_set_use_underline(this->mni_view_zoomin, true);
	g_signal_connect((GtkWidget *) this->mni_view_zoomin, "activate", G_CALLBACK(myapp_on_btn_zoomin_clicked), this);
	gtk_widget_show((GtkWidget *) this->mni_view_zoomin);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_view, (GtkWidget *) this->mni_view_zoomout);
	gtk_menu_item_set_label(this->mni_view_zoomout, "Zoom _Out");
	gtk_menu_item_set_use_underline(this->mni_view_zoomout, true);
	g_signal_connect((GtkWidget *) this->mni_view_zoomout, "activate", G_CALLBACK(myapp_on_btn_zoomout_clicked), this);
	gtk_widget_show((GtkWidget *) this->mni_view_zoomout);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_view, (GtkWidget *) this->mni_view_zoom100);
	gtk_menu_item_set_label(this->mni_view_zoom100, "100% Zoom");
	gtk_menu_item_set_use_underline(this->mni_view_zoom100, true);
	g_signal_connect((GtkWidget *) this->mni_view_zoom100, "activate", G_CALLBACK(myapp_on_btn_zoom100_clicked), this);
	gtk_widget_show((GtkWidget *) this->mni_view_zoom100);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_view, (GtkWidget *) this->mni_view_zoomfit);
	gtk_menu_item_set_label(this->mni_view_zoomfit, "Zoom to _Fit");
	gtk_menu_item_set_use_underline(this->mni_view_zoomfit, true);
	g_signal_connect((GtkWidget *) this->mni_view_zoomfit, "activate", G_CALLBACK(myapp_on_btn_zoomfit_clicked), this);
	gtk_widget_show((GtkWidget *) this->mni_view_zoomfit);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_view, (GtkWidget *) this->mnisep_view_1);
	gtk_widget_show((GtkWidget *) this->mnisep_view_1);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_view, (GtkWidget *) this->mni_view_layers);
	gtk_menu_item_set_label(this->mni_view_layers, "_Layers");
	gtk_menu_item_set_use_underline(this->mni_view_layers, true);
	g_signal_connect((GtkWidget *) this->mni_view_layers, "activate", G_CALLBACK(myapp_on_btn_more_layers_clicked), this);
	gtk_widget_show((GtkWidget *) this->mni_view_layers);
	gtk_widget_show((GtkWidget *) this->mnu_view);
	gtk_widget_show((GtkWidget *) this->mni_view);
	gtk_menu_shell_append((GtkMenuShell *) this->mbr, (GtkWidget *) this->mni_tools);
	gtk_menu_item_set_label(this->mni_tools, "_Tools");
	gtk_menu_item_set_use_underline(this->mni_tools, true);
	gtk_menu_item_set_submenu(this->mni_tools, (GtkWidget *) this->mnu_tools);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_tools, (GtkWidget *) this->mni_tools_pencil);
	gtk_menu_item_set_label(this->mni_tools_pencil, "_Pencil");
	gtk_menu_item_set_use_underline(this->mni_tools_pencil, true);
	g_signal_connect((GtkWidget *) this->mni_tools_pencil, "activate", G_CALLBACK(myapp_on_mni_tool_x_toggled), this);
	gtk_widget_show((GtkWidget *) this->mni_tools_pencil);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_tools, (GtkWidget *) this->mni_tools_brush);
	gtk_menu_item_set_label(this->mni_tools_brush, "_Brush");
	gtk_menu_item_set_use_underline(this->mni_tools_brush, true);
	g_signal_connect((GtkWidget *) this->mni_tools_brush, "activate", G_CALLBACK(myapp_on_mni_tool_x_toggled), this);
	gtk_widget_show((GtkWidget *) this->mni_tools_brush);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_tools, (GtkWidget *) this->mni_tools_eraser);
	gtk_menu_item_set_label(this->mni_tools_eraser, "_Eraser");
	gtk_menu_item_set_use_underline(this->mni_tools_eraser, true);
	g_signal_connect((GtkWidget *) this->mni_tools_eraser, "activate", G_CALLBACK(myapp_on_mni_tool_x_toggled), this);
	gtk_widget_show((GtkWidget *) this->mni_tools_eraser);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_tools, (GtkWidget *) this->mni_tools_floodfill);
	gtk_menu_item_set_label(this->mni_tools_floodfill, "_Fill");
	gtk_menu_item_set_use_underline(this->mni_tools_floodfill, true);
	g_signal_connect((GtkWidget *) this->mni_tools_floodfill, "activate", G_CALLBACK(myapp_on_mni_tool_x_toggled), this);
	gtk_widget_show((GtkWidget *) this->mni_tools_floodfill);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_tools, (GtkWidget *) this->mni_tools_eyedropper);
	gtk_menu_item_set_label(this->mni_tools_eyedropper, "_Eyedropper");
	gtk_menu_item_set_use_underline(this->mni_tools_eyedropper, true);
	g_signal_connect((GtkWidget *) this->mni_tools_eyedropper, "activate", G_CALLBACK(myapp_on_mni_tool_x_toggled), this);
	gtk_widget_show((GtkWidget *) this->mni_tools_eyedropper);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_tools, (GtkWidget *) this->mni_tools_pan);
	gtk_menu_item_set_label(this->mni_tools_pan, "Pa_n");
	gtk_menu_item_set_use_underline(this->mni_tools_pan, true);
	g_signal_connect((GtkWidget *) this->mni_tools_pan, "activate", G_CALLBACK(myapp_on_mni_tool_x_toggled), this);
	gtk_widget_show((GtkWidget *) this->mni_tools_pan);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_tools, (GtkWidget *) this->mni_tools_bplus);
	gtk_menu_item_set_label(this->mni_tools_bplus, "_Increase Brush Size");
	gtk_menu_item_set_use_underline(this->mni_tools_bplus, true);
	g_signal_connect((GtkWidget *) this->mni_tools_bplus, "activate", G_CALLBACK(myapp_on_mni_tools_bplus_activate), this);
	gtk_widget_show((GtkWidget *) this->mni_tools_bplus);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_tools, (GtkWidget *) this->mni_tools_bminus);
	gtk_menu_item_set_label(this->mni_tools_bminus, "_Decrease Brush Size");
	gtk_menu_item_set_use_underline(this->mni_tools_bminus, true);
	g_signal_connect((GtkWidget *) this->mni_tools_bminus, "activate", G_CALLBACK(myapp_on_mni_tools_bminus_activate), this);
	gtk_widget_show((GtkWidget *) this->mni_tools_bminus);
	gtk_widget_show((GtkWidget *) this->mnu_tools);
	gtk_widget_show((GtkWidget *) this->mni_tools);
	gtk_menu_shell_append((GtkMenuShell *) this->mbr, (GtkWidget *) this->mni_help);
	gtk_menu_item_set_label(this->mni_help, "_Help");
	gtk_menu_item_set_use_underline(this->mni_help, true);
	gtk_menu_item_set_submenu(this->mni_help, (GtkWidget *) this->mnu_help);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_help, (GtkWidget *) this->mni_help_topics);
	gtk_menu_item_set_label(this->mni_help_topics, "_Topics");
	gtk_menu_item_set_use_underline(this->mni_help_topics, true);
	gtk_widget_show((GtkWidget *) this->mni_help_topics);
	gtk_menu_shell_append((GtkMenuShell *) this->mnu_help, (GtkWidget *) this->mni_help_about);
	gtk_menu_item_set_label(this->mni_help_about, "_About Vara...");
	gtk_menu_item_set_use_underline(this->mni_help_about, true);
	g_signal_connect((GtkWidget *) this->mni_help_about, "activate", G_CALLBACK(myapp_on_mni_help_about_activate), this);
	gtk_widget_show((GtkWidget *) this->mni_help_about);
	gtk_widget_show((GtkWidget *) this->mnu_help);
	gtk_widget_show((GtkWidget *) this->mni_help);
	gtk_widget_show((GtkWidget *) this->mbr);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_main), GTK_WIDGET((GtkWidget *) this->box_controls2));
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_controls2), GTK_WIDGET((GtkWidget *) this->fme_tools));
	gtk_frame_set_shadow_type(this->fme_tools, GTK_SHADOW_NONE);
	gtk_frame_set_label((GtkFrame *) this->fme_tools, "Tools");
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->fme_tools), GTK_WIDGET((GtkWidget *) this->box_tools));
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_tools), GTK_WIDGET((GtkWidget *) this->btn_pencil));
	gtk_button_set_label((GtkButton *) this->btn_pencil, "Pencil");
	gtk_toggle_button_set_mode((GtkToggleButton *) this->btn_pencil, false);
	gtk_widget_set_tooltip_text((GtkWidget *) this->btn_pencil, "Pencil");
	g_signal_connect((GtkWidget *) this->btn_pencil, "toggled", G_CALLBACK(myapp_on_btn_tool_x_toggled), this);
	gtk_widget_show((GtkWidget *) this->btn_pencil);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_tools), GTK_WIDGET((GtkWidget *) this->btn_brush));
	gtk_button_set_label((GtkButton *) this->btn_brush, "Brush");
	gtk_toggle_button_set_mode((GtkToggleButton *) this->btn_brush, false);
	gtk_widget_set_tooltip_text((GtkWidget *) this->btn_brush, "Brush");
	g_signal_connect((GtkWidget *) this->btn_brush, "toggled", G_CALLBACK(myapp_on_btn_tool_x_toggled), this);
	gtk_widget_show((GtkWidget *) this->btn_brush);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_tools), GTK_WIDGET((GtkWidget *) this->btn_eraser));
	gtk_button_set_label((GtkButton *) this->btn_eraser, "Eraser");
	gtk_toggle_button_set_mode((GtkToggleButton *) this->btn_eraser, false);
	gtk_widget_set_tooltip_text((GtkWidget *) this->btn_eraser, "Eraser");
	g_signal_connect((GtkWidget *) this->btn_eraser, "toggled", G_CALLBACK(myapp_on_btn_tool_x_toggled), this);
	gtk_widget_show((GtkWidget *) this->btn_eraser);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_tools), GTK_WIDGET((GtkWidget *) this->btn_eyedropper));
	gtk_button_set_label((GtkButton *) this->btn_eyedropper, "Eyedropper");
	gtk_toggle_button_set_mode((GtkToggleButton *) this->btn_eyedropper, false);
	gtk_widget_set_tooltip_text((GtkWidget *) this->btn_eyedropper, "Eyedropper");
	g_signal_connect((GtkWidget *) this->btn_eyedropper, "toggled", G_CALLBACK(myapp_on_btn_tool_x_toggled), this);
	gtk_widget_show((GtkWidget *) this->btn_eyedropper);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_tools), GTK_WIDGET((GtkWidget *) this->btn_floodfill));
	gtk_button_set_label((GtkButton *) this->btn_floodfill, "Fill");
	gtk_toggle_button_set_mode((GtkToggleButton *) this->btn_floodfill, false);
	gtk_widget_set_tooltip_text((GtkWidget *) this->btn_floodfill, "Fill");
	g_signal_connect((GtkWidget *) this->btn_floodfill, "toggled", G_CALLBACK(myapp_on_btn_tool_x_toggled), this);
	gtk_widget_show((GtkWidget *) this->btn_floodfill);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_tools), GTK_WIDGET((GtkWidget *) this->btn_pan));
	gtk_button_set_label((GtkButton *) this->btn_pan, "Pan");
	gtk_toggle_button_set_mode((GtkToggleButton *) this->btn_pan, false);
	gtk_widget_set_tooltip_text((GtkWidget *) this->btn_pan, "Pan");
	g_signal_connect((GtkWidget *) this->btn_pan, "toggled", G_CALLBACK(myapp_on_btn_tool_x_toggled), this);
	gtk_widget_show((GtkWidget *) this->btn_pan);
	gtk_widget_show((GtkWidget *) this->box_tools);
	gtk_widget_show((GtkWidget *) this->fme_tools);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_controls2), GTK_WIDGET((GtkWidget *) this->fme_color));
	gtk_frame_set_shadow_type(this->fme_color, GTK_SHADOW_NONE);
	gtk_frame_set_label((GtkFrame *) this->fme_color, "Colour");
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->fme_color), GTK_WIDGET((GtkWidget *) this->box_color));
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_color), GTK_WIDGET((GtkWidget *) this->btn_color));
	g_signal_connect((GtkWidget *) this->btn_color, "color-set", G_CALLBACK(myapp_on_btn_color_set), this);
	gtk_widget_show((GtkWidget *) this->btn_color);
	gtk_widget_show((GtkWidget *) this->box_color);
	gtk_widget_show((GtkWidget *) this->fme_color);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_controls2), GTK_WIDGET((GtkWidget *) this->fme_brushsiz));
	gtk_frame_set_shadow_type(this->fme_brushsiz, GTK_SHADOW_NONE);
	gtk_frame_set_label((GtkFrame *) this->fme_brushsiz, "Brush Size");
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->fme_brushsiz), GTK_WIDGET((GtkWidget *) this->spn_brushsiz));
	gtk_spin_button_set_digits(this->spn_brushsiz, (unsigned int) 0);
	g_signal_connect((GtkWidget *) this->spn_brushsiz, "value-changed", G_CALLBACK(myapp_on_spn_brushsiz_changed), this);
	gtk_widget_show((GtkWidget *) this->spn_brushsiz);
	gtk_widget_show((GtkWidget *) this->fme_brushsiz);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_controls2), GTK_WIDGET((GtkWidget *) this->fme_brushpreview));
	gtk_frame_set_shadow_type(this->fme_brushpreview, GTK_SHADOW_NONE);
	gtk_frame_set_label((GtkFrame *) this->fme_brushpreview, "Brush Preview");
	GtkWidget *_tmp_15 = image_view_get_native_widget(this->iv_brushpreview);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->fme_brushpreview), GTK_WIDGET(_tmp_15));
	Image *_tmp_14 = (Image *) malloc(sizeof(Image));
	if(_tmp_14 == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	image_construct(_tmp_14, 120, 40, 255);
	image_view_set_image(this->iv_brushpreview, _tmp_14);
	image_view_show(this->iv_brushpreview);
	gtk_widget_show((GtkWidget *) this->fme_brushpreview);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_controls2), GTK_WIDGET((GtkWidget *) this->fme_brushes));
	gtk_frame_set_shadow_type(this->fme_brushes, GTK_SHADOW_NONE);
	gtk_frame_set_label((GtkFrame *) this->fme_brushes, "Brush Presets");
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->fme_brushes), GTK_WIDGET((GtkWidget *) this->box_brushes));
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_brushes), GTK_WIDGET((GtkWidget *) this->btn_prebrush_ballpoint));
	gtk_widget_set_tooltip_text((GtkWidget *) this->btn_prebrush_ballpoint, "Ballpoint");
	GtkWidget *_tmp_16 = image_view_get_native_widget(this->ivw_ballpoint);
	gtk_button_set_image(this->btn_prebrush_ballpoint, _tmp_16);
	gtk_button_set_image_position(this->btn_prebrush_ballpoint, GTK_POS_LEFT);
	gtk_button_set_relief(this->btn_prebrush_ballpoint, GTK_RELIEF_NONE);
	g_signal_connect((GtkWidget *) this->btn_prebrush_ballpoint, "clicked", G_CALLBACK(myapp_on_btn_prebrush_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_prebrush_ballpoint);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_brushes), GTK_WIDGET((GtkWidget *) this->btn_prebrush_pencil));
	gtk_widget_set_tooltip_text((GtkWidget *) this->btn_prebrush_pencil, "Pencil");
	GtkWidget *_tmp_17 = image_view_get_native_widget(this->ivw_pencil);
	gtk_button_set_image(this->btn_prebrush_pencil, _tmp_17);
	gtk_button_set_image_position(this->btn_prebrush_pencil, GTK_POS_LEFT);
	gtk_button_set_relief(this->btn_prebrush_pencil, GTK_RELIEF_NONE);
	g_signal_connect((GtkWidget *) this->btn_prebrush_pencil, "clicked", G_CALLBACK(myapp_on_btn_prebrush_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_prebrush_pencil);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_brushes), GTK_WIDGET((GtkWidget *) this->btn_prebrush_crayon));
	gtk_widget_set_tooltip_text((GtkWidget *) this->btn_prebrush_crayon, "Cryaon");
	GtkWidget *_tmp_18 = image_view_get_native_widget(this->ivw_crayon);
	gtk_button_set_image(this->btn_prebrush_crayon, _tmp_18);
	gtk_button_set_image_position(this->btn_prebrush_crayon, GTK_POS_LEFT);
	gtk_button_set_relief(this->btn_prebrush_crayon, GTK_RELIEF_NONE);
	g_signal_connect((GtkWidget *) this->btn_prebrush_crayon, "clicked", G_CALLBACK(myapp_on_btn_prebrush_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_prebrush_crayon);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_brushes), GTK_WIDGET((GtkWidget *) this->btn_prebrush_charcoal));
	gtk_widget_set_tooltip_text((GtkWidget *) this->btn_prebrush_charcoal, "Charcoal");
	GtkWidget *_tmp_19 = image_view_get_native_widget(this->ivw_charcoal);
	gtk_button_set_image(this->btn_prebrush_charcoal, _tmp_19);
	gtk_button_set_image_position(this->btn_prebrush_charcoal, GTK_POS_LEFT);
	gtk_button_set_relief(this->btn_prebrush_charcoal, GTK_RELIEF_NONE);
	g_signal_connect((GtkWidget *) this->btn_prebrush_charcoal, "clicked", G_CALLBACK(myapp_on_btn_prebrush_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_prebrush_charcoal);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_brushes), GTK_WIDGET((GtkWidget *) this->btn_prebrush_round));
	gtk_widget_set_tooltip_text((GtkWidget *) this->btn_prebrush_round, "Round");
	GtkWidget *_tmp_20 = image_view_get_native_widget(this->ivw_round);
	gtk_button_set_image(this->btn_prebrush_round, _tmp_20);
	gtk_button_set_image_position(this->btn_prebrush_round, GTK_POS_LEFT);
	gtk_button_set_relief(this->btn_prebrush_round, GTK_RELIEF_NONE);
	g_signal_connect((GtkWidget *) this->btn_prebrush_round, "clicked", G_CALLBACK(myapp_on_btn_prebrush_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_prebrush_round);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_brushes), GTK_WIDGET((GtkWidget *) this->btn_prebrush_round_pressure_size));
	gtk_widget_set_tooltip_text((GtkWidget *) this->btn_prebrush_round_pressure_size, "Round Pr. Size");
	GtkWidget *_tmp_21 = image_view_get_native_widget(this->ivw_round_pressure_size);
	gtk_button_set_image(this->btn_prebrush_round_pressure_size, _tmp_21);
	gtk_button_set_image_position(this->btn_prebrush_round_pressure_size, GTK_POS_LEFT);
	gtk_button_set_relief(this->btn_prebrush_round_pressure_size, GTK_RELIEF_NONE);
	g_signal_connect((GtkWidget *) this->btn_prebrush_round_pressure_size, "clicked", G_CALLBACK(myapp_on_btn_prebrush_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_prebrush_round_pressure_size);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_brushes), GTK_WIDGET((GtkWidget *) this->btn_prebrush_soft_round));
	gtk_widget_set_tooltip_text((GtkWidget *) this->btn_prebrush_soft_round, "Soft Round");
	GtkWidget *_tmp_22 = image_view_get_native_widget(this->ivw_soft_round);
	gtk_button_set_image(this->btn_prebrush_soft_round, _tmp_22);
	gtk_button_set_image_position(this->btn_prebrush_soft_round, GTK_POS_LEFT);
	gtk_button_set_relief(this->btn_prebrush_soft_round, GTK_RELIEF_NONE);
	g_signal_connect((GtkWidget *) this->btn_prebrush_soft_round, "clicked", G_CALLBACK(myapp_on_btn_prebrush_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_prebrush_soft_round);
	gtk_widget_show((GtkWidget *) this->box_brushes);
	gtk_widget_show((GtkWidget *) this->fme_brushes);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_controls2), GTK_WIDGET((GtkWidget *) this->fme_advanced));
	gtk_frame_set_shadow_type(this->fme_advanced, GTK_SHADOW_NONE);
	gtk_widget_set_hexpand((GtkWidget *) this->fme_advanced, true);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->fme_advanced), GTK_WIDGET((GtkWidget *) this->box_advanced));
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_advanced), GTK_WIDGET((GtkWidget *) this->chk_scratch));
	gtk_button_set_label((GtkButton *) this->chk_scratch, "Scratchpad");
	g_signal_connect((GtkWidget *) this->chk_scratch, "toggled", G_CALLBACK(myapp_on_chk_scratch_toggled), this);
	gtk_widget_show((GtkWidget *) this->chk_scratch);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_advanced), GTK_WIDGET((GtkWidget *) this->chk_advanced));
	gtk_button_set_label((GtkButton *) this->chk_advanced, "Advanced");
	g_signal_connect((GtkWidget *) this->chk_advanced, "toggled", G_CALLBACK(myapp_on_chk_advanced_toggled), this);
	gtk_widget_show((GtkWidget *) this->chk_advanced);
	gtk_widget_show((GtkWidget *) this->box_advanced);
	gtk_widget_show((GtkWidget *) this->fme_advanced);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_controls2), GTK_WIDGET((GtkWidget *) this->fme_history));
	gtk_frame_set_shadow_type(this->fme_history, GTK_SHADOW_NONE);
	gtk_frame_set_label((GtkFrame *) this->fme_history, "History");
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->fme_history), GTK_WIDGET((GtkWidget *) this->box_history));
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_history), GTK_WIDGET((GtkWidget *) this->btn_undo));
	gtk_button_set_label(this->btn_undo, "Undo");
	gtk_widget_set_sensitive((GtkWidget *) this->btn_undo, false);
	g_signal_connect((GtkWidget *) this->btn_undo, "clicked", G_CALLBACK(myapp_on_btn_undo_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_undo);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_history), GTK_WIDGET((GtkWidget *) this->btn_redo));
	gtk_button_set_label(this->btn_redo, "Redo");
	gtk_widget_set_sensitive((GtkWidget *) this->btn_redo, false);
	g_signal_connect((GtkWidget *) this->btn_redo, "clicked", G_CALLBACK(myapp_on_btn_redo_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_redo);
	gtk_widget_show((GtkWidget *) this->box_history);
	gtk_widget_show((GtkWidget *) this->fme_history);
	gtk_widget_show((GtkWidget *) this->box_controls2);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_main), GTK_WIDGET((GtkWidget *) this->grd_viewport));
	gtk_grid_attach(this->grd_viewport, (GtkWidget *) this->da, 0, 0, 1, 1);
	g_signal_connect((GtkWidget *) this->da, "size-allocate", G_CALLBACK(myapp_on_da_sizeallocate), this);
	gtk_widget_set_hexpand((GtkWidget *) this->da, true);
	gtk_widget_set_vexpand((GtkWidget *) this->da, true);
	gtk_widget_show((GtkWidget *) this->da);
	gtk_grid_attach(this->grd_viewport, (GtkWidget *) this->vscroll, 1, 0, 1, 1);
	gtk_range_set_slider_size_fixed((GtkRange *) this->vscroll, false);
	gtk_adjustment_set_step_increment(gtk_range_get_adjustment((GtkRange *) this->vscroll), 1);
	g_signal_connect((GtkWidget *) this->vscroll, "value-changed", G_CALLBACK(myapp_on_vscroll_valuechanged), this);
	gtk_widget_show((GtkWidget *) this->vscroll);
	gtk_grid_attach(this->grd_viewport, (GtkWidget *) this->hscroll, 0, 1, 1, 1);
	gtk_widget_set_hexpand((GtkWidget *) this->hscroll, true);
	gtk_range_set_slider_size_fixed((GtkRange *) this->hscroll, false);
	gtk_adjustment_set_step_increment(gtk_range_get_adjustment((GtkRange *) this->hscroll), 1);
	g_signal_connect((GtkWidget *) this->hscroll, "value-changed", G_CALLBACK(myapp_on_hscroll_valuechanged), this);
	gtk_widget_show((GtkWidget *) this->hscroll);
	gtk_grid_attach(this->grd_viewport, (GtkWidget *) this->nbk_advanced, 2, 0, 1, 2);
	gtk_widget_set_visible((GtkWidget *) this->nbk_advanced, false);
	gtk_widget_show((GtkWidget *) this->grd_viewport);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_main), GTK_WIDGET((GtkWidget *) this->grd_bottom));
	gtk_grid_attach(this->grd_bottom, (GtkWidget *) this->box_newdoc, 0, 0, 1, 1);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_newdoc), GTK_WIDGET((GtkWidget *) this->fme_newdoc));
	gtk_frame_set_shadow_type(this->fme_newdoc, GTK_SHADOW_NONE);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->fme_newdoc), GTK_WIDGET((GtkWidget *) this->hbx_newdoc));
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->hbx_newdoc), GTK_WIDGET((GtkWidget *) this->btn_export_doc));
	gtk_button_set_label(this->btn_export_doc, "Export");
	g_signal_connect((GtkWidget *) this->btn_export_doc, "clicked", G_CALLBACK(myapp_on_btn_export_doc_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_export_doc);
	gtk_widget_show((GtkWidget *) this->hbx_newdoc);
	gtk_widget_show((GtkWidget *) this->fme_newdoc);
	gtk_widget_show((GtkWidget *) this->box_newdoc);
	gtk_grid_attach(this->grd_bottom, (GtkWidget *) this->box_controls1, 1, 0, 1, 1);
	gtk_widget_set_hexpand((GtkWidget *) this->box_controls1, true);
	gtk_box_set_spacing(this->box_controls1, 24);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_controls1), GTK_WIDGET((GtkWidget *) this->fme_quicklayers));
	gtk_frame_set_shadow_type(this->fme_quicklayers, GTK_SHADOW_NONE);
	gtk_frame_set_label((GtkFrame *) this->fme_quicklayers, "Active Layer");
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->fme_quicklayers), GTK_WIDGET((GtkWidget *) this->box_quicklayers));
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_quicklayers), GTK_WIDGET((GtkWidget *) this->btn_fglayer));
	gtk_button_set_label((GtkButton *) this->btn_fglayer, "FG");
	gtk_toggle_button_set_mode((GtkToggleButton *) this->btn_fglayer, false);
	g_signal_connect((GtkWidget *) this->btn_fglayer, "toggled", G_CALLBACK(myapp_on_btn_xlayer_toggled), this);
	gtk_widget_show((GtkWidget *) this->btn_fglayer);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_quicklayers), GTK_WIDGET((GtkWidget *) this->btn_bglayer));
	gtk_button_set_label((GtkButton *) this->btn_bglayer, "BG");
	gtk_toggle_button_set_mode((GtkToggleButton *) this->btn_bglayer, false);
	g_signal_connect((GtkWidget *) this->btn_bglayer, "toggled", G_CALLBACK(myapp_on_btn_xlayer_toggled), this);
	gtk_widget_show((GtkWidget *) this->btn_bglayer);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_quicklayers), GTK_WIDGET((GtkWidget *) this->btn_more_layers));
	gtk_button_set_label(this->btn_more_layers, "...");
	g_signal_connect((GtkWidget *) this->btn_more_layers, "clicked", G_CALLBACK(myapp_on_btn_more_layers_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_more_layers);
	gtk_widget_show((GtkWidget *) this->box_quicklayers);
	gtk_widget_show((GtkWidget *) this->fme_quicklayers);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_controls1), GTK_WIDGET((GtkWidget *) this->fme_layer_visibility));
	gtk_frame_set_shadow_type(this->fme_layer_visibility, GTK_SHADOW_NONE);
	gtk_frame_set_label((GtkFrame *) this->fme_layer_visibility, "Layer Visibility");
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->fme_layer_visibility), GTK_WIDGET((GtkWidget *) this->box_layer_visibility));
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_layer_visibility), GTK_WIDGET((GtkWidget *) this->chk_fg_visible));
	gtk_button_set_label((GtkButton *) this->chk_fg_visible, "FG");
	g_signal_connect((GtkWidget *) this->chk_fg_visible, "toggled", G_CALLBACK(myapp_on_chk_fg_visible_toggled), this);
	gtk_widget_show((GtkWidget *) this->chk_fg_visible);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_layer_visibility), GTK_WIDGET((GtkWidget *) this->chk_bg_visible));
	gtk_button_set_label((GtkButton *) this->chk_bg_visible, "BG");
	g_signal_connect((GtkWidget *) this->chk_bg_visible, "toggled", G_CALLBACK(myapp_on_chk_bg_visible_toggled), this);
	gtk_widget_show((GtkWidget *) this->chk_bg_visible);
	gtk_widget_show((GtkWidget *) this->box_layer_visibility);
	gtk_widget_show((GtkWidget *) this->fme_layer_visibility);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_controls1), GTK_WIDGET((GtkWidget *) this->fme_layeracts));
	gtk_frame_set_shadow_type(this->fme_layeracts, GTK_SHADOW_NONE);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->fme_layeracts), GTK_WIDGET((GtkWidget *) this->box_layeracts));
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_layeracts), GTK_WIDGET((GtkWidget *) this->btn_layer_fillbgcolor));
	gtk_button_set_label(this->btn_layer_fillbgcolor, "Wipe Layer");
	g_signal_connect((GtkWidget *) this->btn_layer_fillbgcolor, "clicked", G_CALLBACK(myapp_on_mni_fill_bgcolor_activate), this);
	gtk_widget_show((GtkWidget *) this->btn_layer_fillbgcolor);
	gtk_widget_show((GtkWidget *) this->box_layeracts);
	gtk_widget_show((GtkWidget *) this->fme_layeracts);
	GtkWidget *_tmp_23 = image_view_get_native_widget((ImageView *) this->quickpalette);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_controls1), GTK_WIDGET(_tmp_23));
	quick_palette_set_hexpand(this->quickpalette, true);
	this->quickpalette->oncolorset_callback = myapp_on_quickpalette_colorset;

	this->quickpalette->oncolorset_data = this;
	image_view_show((ImageView *) this->quickpalette);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_controls1), GTK_WIDGET((GtkWidget *) this->fme_zoom));
	gtk_frame_set_shadow_type(this->fme_zoom, GTK_SHADOW_NONE);
	gtk_frame_set_label((GtkFrame *) this->fme_zoom, "Zoom");
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->fme_zoom), GTK_WIDGET((GtkWidget *) this->tbr_zoom));
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->tbr_zoom), GTK_WIDGET((GtkWidget *) this->btn_center));
	gtk_tool_button_set_label(this->btn_center, "C");
	gtk_tool_button_set_icon_name(this->btn_center, "format-justify-center");
	gtk_widget_set_tooltip_text((GtkWidget *) this->btn_center, "Center");
	g_signal_connect((GtkWidget *) this->btn_center, "clicked", G_CALLBACK(myapp_on_btn_center_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_center);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->tbr_zoom), GTK_WIDGET((GtkWidget *) this->btn_zoom100));
	gtk_tool_button_set_label(this->btn_zoom100, "100%");
	gtk_tool_button_set_icon_name(this->btn_zoom100, "zoom-original");
	gtk_widget_set_tooltip_text((GtkWidget *) this->btn_zoom100, "Zoom 100%");
	g_signal_connect((GtkWidget *) this->btn_zoom100, "clicked", G_CALLBACK(myapp_on_btn_zoom100_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_zoom100);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->tbr_zoom), GTK_WIDGET((GtkWidget *) this->btn_zoomout));
	gtk_tool_button_set_label(this->btn_zoomout, "Z-");
	gtk_tool_button_set_icon_name(this->btn_zoomout, "zoom-out");
	gtk_widget_set_tooltip_text((GtkWidget *) this->btn_zoomout, "Zoom out");
	gtk_widget_set_sensitive((GtkWidget *) this->btn_zoomout, false);
	g_signal_connect((GtkWidget *) this->btn_zoomout, "clicked", G_CALLBACK(myapp_on_btn_zoomout_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_zoomout);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->tbr_zoom), GTK_WIDGET((GtkWidget *) this->btn_zoomin));
	gtk_tool_button_set_label(this->btn_zoomin, "Z+");
	gtk_widget_set_tooltip_text((GtkWidget *) this->btn_zoomin, "Zoom in");
	gtk_tool_button_set_icon_name(this->btn_zoomin, "zoom-in");
	gtk_widget_set_sensitive((GtkWidget *) this->btn_zoomin, false);
	g_signal_connect((GtkWidget *) this->btn_zoomin, "clicked", G_CALLBACK(myapp_on_btn_zoomin_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_zoomin);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->tbr_zoom), GTK_WIDGET((GtkWidget *) this->tbi_lbl_zoom));
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->tbi_lbl_zoom), GTK_WIDGET((GtkWidget *) this->lbl_zoom));
	gtk_widget_set_size_request((GtkWidget *) this->lbl_zoom, MINWIDTH_LBL_ZOOM_SIZE, -1);
	gtk_widget_show((GtkWidget *) this->lbl_zoom);
	gtk_widget_show((GtkWidget *) this->tbi_lbl_zoom);
	gtk_widget_show((GtkWidget *) this->tbr_zoom);
	gtk_widget_show((GtkWidget *) this->fme_zoom);
	gtk_widget_show((GtkWidget *) this->box_controls1);
	gtk_widget_show((GtkWidget *) this->grd_bottom);
	gtk_widget_show((GtkWidget *) this->box_main);

	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_brushopts), GTK_WIDGET((GtkWidget *) this->cbo_brush_engine));
	g_signal_connect((GtkWidget *) this->cbo_brush_engine, "changed", G_CALLBACK(myapp_on_cbo_brush_engine_changed), this);
	gtk_widget_show((GtkWidget *) this->cbo_brush_engine);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_brushopts), GTK_WIDGET((GtkWidget *) this->chk_pressure));
	gtk_button_set_label((GtkButton *) this->chk_pressure, "Pressure");
	g_signal_connect((GtkWidget *) this->chk_pressure, "toggled", G_CALLBACK(myapp_on_chk_pressure_toggled), this);
	gtk_widget_show((GtkWidget *) this->chk_pressure);
	GtkGrid *_tmp_24 = entry_slider_get_native_widget(this->sldr_brush_opacity);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_brushopts), GTK_WIDGET((GtkWidget *) _tmp_24));
	entry_slider_set_label(this->sldr_brush_opacity, "Opacity: ");
	entry_slider_set_onchanged(this->sldr_brush_opacity, myapp_on_sldr_brush_x_changed, this);
	entry_slider_show(this->sldr_brush_opacity);
	GtkGrid *_tmp_25 = entry_slider_get_native_widget(this->sldr_brush_softness);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_brushopts), GTK_WIDGET((GtkWidget *) _tmp_25));
	entry_slider_set_label(this->sldr_brush_softness, "Softness: ");
	entry_slider_set_onchanged(this->sldr_brush_softness, myapp_on_sldr_brush_x_changed, this);
	entry_slider_show(this->sldr_brush_softness);
	GtkGrid *_tmp_26 = entry_slider_get_native_widget(this->sldr_brush_aaradius_circle1);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_brushopts), GTK_WIDGET((GtkWidget *) _tmp_26));
	entry_slider_set_label(this->sldr_brush_aaradius_circle1, "Anti-aliasing: ");
	entry_slider_set_onchanged(this->sldr_brush_aaradius_circle1, myapp_on_sldr_brush_x_changed, this);
	entry_slider_show(this->sldr_brush_aaradius_circle1);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_brushopts), GTK_WIDGET((GtkWidget *) this->hbx_scatter_type));
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->hbx_scatter_type), GTK_WIDGET((GtkWidget *) this->lbl_scatter_type));
	gtk_label_set_label(this->lbl_scatter_type, "Scatter: ");
	gtk_widget_show((GtkWidget *) this->lbl_scatter_type);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->hbx_scatter_type), GTK_WIDGET((GtkWidget *) this->rad_scatter_type_none));
	gtk_button_set_label((GtkButton *) this->rad_scatter_type_none, "None");
	g_signal_connect((GtkWidget *) this->rad_scatter_type_none, "toggled", G_CALLBACK(myapp_on_rad_scatter_type_x_toggled), this);
	gtk_widget_show((GtkWidget *) this->rad_scatter_type_none);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->hbx_scatter_type), GTK_WIDGET((GtkWidget *) this->rad_scatter_type_circle));
	gtk_button_set_label((GtkButton *) this->rad_scatter_type_circle, "Circle");
	g_signal_connect((GtkWidget *) this->rad_scatter_type_circle, "toggled", G_CALLBACK(myapp_on_rad_scatter_type_x_toggled), this);
	gtk_widget_show((GtkWidget *) this->rad_scatter_type_circle);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->hbx_scatter_type), GTK_WIDGET((GtkWidget *) this->rad_scatter_type_square));
	gtk_button_set_label((GtkButton *) this->rad_scatter_type_square, "Square");
	g_signal_connect((GtkWidget *) this->rad_scatter_type_square, "toggled", G_CALLBACK(myapp_on_rad_scatter_type_x_toggled), this);
	gtk_widget_show((GtkWidget *) this->rad_scatter_type_square);
	gtk_widget_show((GtkWidget *) this->hbx_scatter_type);
	GtkGrid *_tmp_27 = entry_slider_get_native_widget(this->sldr_brush_scatter_radius);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_brushopts), GTK_WIDGET((GtkWidget *) _tmp_27));
	entry_slider_set_label(this->sldr_brush_scatter_radius, "Scatter Radius: ");
	entry_slider_set_onchanged(this->sldr_brush_scatter_radius, myapp_on_sldr_brush_x_changed, this);
	entry_slider_show(this->sldr_brush_scatter_radius);
	GtkGrid *_tmp_28 = entry_slider_get_native_widget(this->sldr_brush_scatter_density);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_brushopts), GTK_WIDGET((GtkWidget *) _tmp_28));
	entry_slider_set_label(this->sldr_brush_scatter_density, "Scatter Density: ");
	entry_slider_set_onchanged(this->sldr_brush_scatter_density, myapp_on_sldr_brush_x_changed, this);
	entry_slider_show(this->sldr_brush_scatter_density);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_brushopts), GTK_WIDGET((GtkWidget *) this->chk_scatter_take_pressure));
	gtk_button_set_label((GtkButton *) this->chk_scatter_take_pressure, "Pressurize Scatter");
	g_signal_connect((GtkWidget *) this->chk_scatter_take_pressure, "toggled", G_CALLBACK(myapp_on_chk_scatter_take_pressure_toggled), this);
	gtk_widget_show((GtkWidget *) this->chk_scatter_take_pressure);
	gtk_widget_show((GtkWidget *) this->box_brushopts);

	GtkGrid *_tmp_29 = entry_slider_get_native_widget(this->sldr_stroke_smoothness);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_strokeopts), GTK_WIDGET((GtkWidget *) _tmp_29));
	entry_slider_set_label(this->sldr_stroke_smoothness, "Smoothness: ");
	entry_slider_set_onchanged(this->sldr_stroke_smoothness, myapp_on_sldr_stroke_smoothness_changed, this);
	entry_slider_show(this->sldr_stroke_smoothness);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_strokeopts), GTK_WIDGET((GtkWidget *) this->chk_subpixel_when_zoomed));
	gtk_button_set_label((GtkButton *) this->chk_subpixel_when_zoomed, "Subpixel");
	g_signal_connect((GtkWidget *) this->chk_subpixel_when_zoomed, "toggled", G_CALLBACK(myapp_on_chk_subpixel_when_zoomed_toggled), this);
	gtk_widget_show((GtkWidget *) this->chk_subpixel_when_zoomed);
	gtk_widget_show((GtkWidget *) this->box_strokeopts);

	GtkGrid *_tmp_30 = entry_slider_get_native_widget(this->sldr_color_hue);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_coloropts), GTK_WIDGET((GtkWidget *) _tmp_30));
	entry_slider_set_label(this->sldr_color_hue, "Hue (degree): ");
	entry_slider_set_onchanged(this->sldr_color_hue, myapp_on_hsl_sliders_changed, this);
	entry_slider_show(this->sldr_color_hue);
	GtkGrid *_tmp_31 = entry_slider_get_native_widget(this->sldr_color_sat);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_coloropts), GTK_WIDGET((GtkWidget *) _tmp_31));
	entry_slider_set_label(this->sldr_color_sat, "Saturation (%): ");
	entry_slider_set_onchanged(this->sldr_color_sat, myapp_on_hsl_sliders_changed, this);
	entry_slider_show(this->sldr_color_sat);
	GtkGrid *_tmp_32 = entry_slider_get_native_widget(this->sldr_color_lit);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_coloropts), GTK_WIDGET((GtkWidget *) _tmp_32));
	entry_slider_set_label(this->sldr_color_lit, "Lightness (%): ");
	entry_slider_set_onchanged(this->sldr_color_lit, myapp_on_hsl_sliders_changed, this);
	entry_slider_show(this->sldr_color_lit);
	gtk_widget_show((GtkWidget *) this->box_coloropts);

	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_layers), GTK_WIDGET((GtkWidget *) this->tbr_layers));
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->tbr_layers), GTK_WIDGET((GtkWidget *) this->btn_layer_new));
	gtk_tool_button_set_label(this->btn_layer_new, "Add");
	gtk_tool_button_set_icon_name(this->btn_layer_new, "document-new");
	gtk_widget_set_tooltip_text((GtkWidget *) this->btn_layer_new, "Create a new layer");
	g_signal_connect((GtkWidget *) this->btn_layer_new, "clicked", G_CALLBACK(myapp_on_btn_layer_new_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_layer_new);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->tbr_layers), GTK_WIDGET((GtkWidget *) this->btn_layer_move_up));
	gtk_tool_button_set_label(this->btn_layer_move_up, "Up");
	gtk_tool_button_set_icon_name(this->btn_layer_move_up, "go-up");
	gtk_widget_set_tooltip_text((GtkWidget *) this->btn_layer_move_up, "Move the selected layer up");
	g_signal_connect((GtkWidget *) this->btn_layer_move_up, "clicked", G_CALLBACK(myapp_on_btn_layer_move_up_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_layer_move_up);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->tbr_layers), GTK_WIDGET((GtkWidget *) this->btn_layer_move_down));
	gtk_tool_button_set_label(this->btn_layer_move_down, "Down");
	gtk_tool_button_set_icon_name(this->btn_layer_move_down, "go-down");
	gtk_widget_set_tooltip_text((GtkWidget *) this->btn_layer_move_down, "Move the selected layer down");
	g_signal_connect((GtkWidget *) this->btn_layer_move_down, "clicked", G_CALLBACK(myapp_on_btn_layer_move_down_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_layer_move_down);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->tbr_layers), GTK_WIDGET((GtkWidget *) this->btn_layer_rename));
	gtk_tool_button_set_label(this->btn_layer_rename, "Rename");
	gtk_tool_button_set_icon_name(this->btn_layer_rename, "document-properties");
	gtk_widget_set_tooltip_text((GtkWidget *) this->btn_layer_rename, "Rename the selected layer");
	g_signal_connect((GtkWidget *) this->btn_layer_rename, "clicked", G_CALLBACK(myapp_on_btn_layer_rename_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_layer_rename);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->tbr_layers), GTK_WIDGET((GtkWidget *) this->btn_layer_delete));
	gtk_tool_button_set_label(this->btn_layer_delete, "Delete");
	gtk_tool_button_set_icon_name(this->btn_layer_delete, "edit-delete");
	gtk_widget_set_tooltip_text((GtkWidget *) this->btn_layer_delete, "Delete the selected layer");
	g_signal_connect((GtkWidget *) this->btn_layer_delete, "clicked", G_CALLBACK(myapp_on_btn_layer_delete_clicked), this);
	gtk_widget_show((GtkWidget *) this->btn_layer_delete);
	gtk_widget_show((GtkWidget *) this->tbr_layers);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_layers), GTK_WIDGET((GtkWidget *) this->sw_layers));
	gtk_widget_set_vexpand((GtkWidget *) this->sw_layers, true);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->sw_layers), GTK_WIDGET((GtkWidget *) this->lst_layers));
	g_signal_connect((GtkWidget *) this->lst_layers, "row-selected", G_CALLBACK(myapp_on_lst_layers_row_selected), this);
	gtk_widget_show((GtkWidget *) this->lst_layers);
	gtk_widget_show((GtkWidget *) this->sw_layers);
	GtkGrid *_tmp_33 = entry_slider_get_native_widget(this->sldr_layer_opacity);
	gtk_container_add(GTK_CONTAINER((GtkWidget *) this->box_layers), GTK_WIDGET((GtkWidget *) _tmp_33));
	entry_slider_set_label(this->sldr_layer_opacity, "Opacity: ");
	entry_slider_set_onchanged(this->sldr_layer_opacity, myapp_on_sldr_layer_opacity_changed, this);
	entry_slider_show(this->sldr_layer_opacity);
	gtk_widget_show((GtkWidget *) this->box_layers);

	gtk_notebook_append_page(this->nbk_advanced, (GtkWidget *) this->box_brushopts, (GtkWidget *) gtk_label_new("Brush"));
	gtk_notebook_append_page(this->nbk_advanced, (GtkWidget *) this->box_strokeopts, (GtkWidget *) gtk_label_new("Stroke"));
	gtk_notebook_append_page(this->nbk_advanced, (GtkWidget *) this->box_coloropts, (GtkWidget *) gtk_label_new("Colour"));
	gtk_notebook_append_page(this->nbk_advanced, (GtkWidget *) this->box_layers, (GtkWidget *) gtk_label_new("Layers"));

	this->toolicons = draw_icons();
	assert(this->toolicons);
	ToolIcons *tinn = this->toolicons;
	assert(tinn->img_pencil);
	set_tool_icon((GtkButton *) this->btn_pencil, tinn->img_pencil);
	assert(tinn->img_brush);
	set_tool_icon((GtkButton *) this->btn_brush, tinn->img_brush);
	assert(tinn->img_eraser);
	set_tool_icon((GtkButton *) this->btn_eraser, tinn->img_eraser);
	assert(tinn->img_eyedropper);
	set_tool_icon((GtkButton *) this->btn_eyedropper, tinn->img_eyedropper);
	assert(tinn->img_floodfill);
	set_tool_icon((GtkButton *) this->btn_floodfill, tinn->img_floodfill);
	assert(tinn->img_pan);
	set_tool_icon((GtkButton *) this->btn_pan, tinn->img_pan);

	unsigned int accelkey = 0u;
	GdkModifierType accelmods = (GdkModifierType) 0;
	gtk_accelerator_parse("<Ctrl>n", &accelkey, &accelmods);

	gtk_widget_add_accelerator((GtkWidget *) this->mni_file_new, "activate", this->accgrp, accelkey, accelmods, GTK_ACCEL_VISIBLE);
	unsigned int _ngg_tmp_84_accelkey = 0u;
	GdkModifierType _ngg_tmp_86_accelmods = (GdkModifierType) 0;
	gtk_accelerator_parse("<Ctrl>o", &_ngg_tmp_84_accelkey, &_ngg_tmp_86_accelmods);

	gtk_widget_add_accelerator((GtkWidget *) this->mni_file_open, "activate", this->accgrp, _ngg_tmp_84_accelkey, _ngg_tmp_86_accelmods, GTK_ACCEL_VISIBLE);
	unsigned int _ngg_tmp_88_accelkey = 0u;
	GdkModifierType _ngg_tmp_90_accelmods = (GdkModifierType) 0;
	gtk_accelerator_parse("<Shift><Ctrl>s", &_ngg_tmp_88_accelkey, &_ngg_tmp_90_accelmods);

	gtk_widget_add_accelerator((GtkWidget *) this->mni_file_save_as, "activate", this->accgrp, _ngg_tmp_88_accelkey, _ngg_tmp_90_accelmods, GTK_ACCEL_VISIBLE);
	unsigned int _ngg_tmp_92_accelkey = 0u;
	GdkModifierType _ngg_tmp_94_accelmods = (GdkModifierType) 0;
	gtk_accelerator_parse("<Ctrl>e", &_ngg_tmp_92_accelkey, &_ngg_tmp_94_accelmods);

	gtk_widget_add_accelerator((GtkWidget *) this->mni_file_export, "activate", this->accgrp, _ngg_tmp_92_accelkey, _ngg_tmp_94_accelmods, GTK_ACCEL_VISIBLE);
	unsigned int _ngg_tmp_96_accelkey = 0u;
	GdkModifierType _ngg_tmp_98_accelmods = (GdkModifierType) 0;
	gtk_accelerator_parse("<Ctrl>q", &_ngg_tmp_96_accelkey, &_ngg_tmp_98_accelmods);

	gtk_widget_add_accelerator((GtkWidget *) this->mni_file_quit, "activate", this->accgrp, _ngg_tmp_96_accelkey, _ngg_tmp_98_accelmods, GTK_ACCEL_VISIBLE);
	unsigned int _ngg_tmp_10_accelkey = 0u;
	GdkModifierType _ngg_tmp_102_accelmods = (GdkModifierType) 0;
	gtk_accelerator_parse("<Ctrl>z", &_ngg_tmp_10_accelkey, &_ngg_tmp_102_accelmods);

	gtk_widget_add_accelerator((GtkWidget *) this->mni_edit_undo, "activate", this->accgrp, _ngg_tmp_10_accelkey, _ngg_tmp_102_accelmods, GTK_ACCEL_VISIBLE);
	unsigned int _ngg_tmp_104_accelkey = 0u;
	GdkModifierType _ngg_tmp_106_accelmods = (GdkModifierType) 0;
	gtk_accelerator_parse("<Ctrl><Shift>z", &_ngg_tmp_104_accelkey, &_ngg_tmp_106_accelmods);

	gtk_widget_add_accelerator((GtkWidget *) this->mni_edit_redo, "activate", this->accgrp, _ngg_tmp_104_accelkey, _ngg_tmp_106_accelmods, GTK_ACCEL_VISIBLE);
	unsigned int _ngg_tmp_108_accelkey = 0u;
	GdkModifierType _ngg_tmp_110_accelmods = (GdkModifierType) 0;
	gtk_accelerator_parse("<Ctrl>Delete", &_ngg_tmp_108_accelkey, &_ngg_tmp_110_accelmods);

	gtk_widget_add_accelerator((GtkWidget *) this->mni_edit_clear, "activate", this->accgrp, _ngg_tmp_108_accelkey, _ngg_tmp_110_accelmods, GTK_ACCEL_VISIBLE);
	unsigned int _ngg_tmp_112_accelkey = 0u;
	GdkModifierType _ngg_tmp_114_accelmods = (GdkModifierType) 0;
	gtk_accelerator_parse("<Ctrl>BackSpace", &_ngg_tmp_112_accelkey, &_ngg_tmp_114_accelmods);

	gtk_widget_add_accelerator((GtkWidget *) this->mni_edit_fill_bgcolor, "activate", this->accgrp, _ngg_tmp_112_accelkey, _ngg_tmp_114_accelmods, GTK_ACCEL_VISIBLE);
	unsigned int _ngg_tmp_116_accelkey = 0u;
	GdkModifierType _ngg_tmp_118_accelmods = (GdkModifierType) 0;
	gtk_accelerator_parse("<Shift>BackSpace", &_ngg_tmp_116_accelkey, &_ngg_tmp_118_accelmods);

	gtk_widget_add_accelerator((GtkWidget *) this->mni_edit_fill_fgcolor, "activate", this->accgrp, _ngg_tmp_116_accelkey, _ngg_tmp_118_accelmods, GTK_ACCEL_VISIBLE);
	unsigned int _ngg_tmp_120_accelkey = 0u;
	GdkModifierType _ngg_tmp_122_accelmods = (GdkModifierType) 0;
	gtk_accelerator_parse("<Ctrl>equal", &_ngg_tmp_120_accelkey, &_ngg_tmp_122_accelmods);

	gtk_widget_add_accelerator((GtkWidget *) this->mni_view_zoomin, "activate", this->accgrp, _ngg_tmp_120_accelkey, _ngg_tmp_122_accelmods, GTK_ACCEL_VISIBLE);
	unsigned int _ngg_tmp_124_accelkey = 0u;
	GdkModifierType _ngg_tmp_126_accelmods = (GdkModifierType) 0;
	gtk_accelerator_parse("<Ctrl>minus", &_ngg_tmp_124_accelkey, &_ngg_tmp_126_accelmods);

	gtk_widget_add_accelerator((GtkWidget *) this->mni_view_zoomout, "activate", this->accgrp, _ngg_tmp_124_accelkey, _ngg_tmp_126_accelmods, GTK_ACCEL_VISIBLE);

	unsigned int _ngg_tmp_128_accelkey = 0u;
	GdkModifierType _ngg_tmp_130_accelmods = (GdkModifierType) 0;
	gtk_accelerator_parse("<Ctrl>1", &_ngg_tmp_128_accelkey, &_ngg_tmp_130_accelmods);

	gtk_widget_add_accelerator((GtkWidget *) this->mni_view_zoom100, "activate", this->accgrp, _ngg_tmp_128_accelkey, _ngg_tmp_130_accelmods, GTK_ACCEL_VISIBLE);
	unsigned int _ngg_tmp_132_accelkey = 0u;
	GdkModifierType _ngg_tmp_134_accelmods = (GdkModifierType) 0;
	gtk_accelerator_parse("<Ctrl>0", &_ngg_tmp_132_accelkey, &_ngg_tmp_134_accelmods);

	gtk_widget_add_accelerator((GtkWidget *) this->mni_view_zoomfit, "activate", this->accgrp, _ngg_tmp_132_accelkey, _ngg_tmp_134_accelmods, GTK_ACCEL_VISIBLE);
	unsigned int _ngg_tmp_136_accelkey = 0u;
	GdkModifierType _ngg_tmp_138_accelmods = (GdkModifierType) 0;
	gtk_accelerator_parse("<Ctrl>l", &_ngg_tmp_136_accelkey, &_ngg_tmp_138_accelmods);

	gtk_widget_add_accelerator((GtkWidget *) this->mni_view_layers, "activate", this->accgrp, _ngg_tmp_136_accelkey, _ngg_tmp_138_accelmods, GTK_ACCEL_VISIBLE);
	unsigned int _ngg_tmp_140_accelkey = 0u;
	GdkModifierType _ngg_tmp_142_accelmods = (GdkModifierType) 0;
	gtk_accelerator_parse("b", &_ngg_tmp_140_accelkey, &_ngg_tmp_142_accelmods);

	gtk_widget_add_accelerator((GtkWidget *) this->mni_tools_brush, "activate", this->accgrp, _ngg_tmp_140_accelkey, _ngg_tmp_142_accelmods, GTK_ACCEL_VISIBLE);
	unsigned int _ngg_tmp_144_accelkey = 0u;
	GdkModifierType _ngg_tmp_146_accelmods = (GdkModifierType) 0;
	gtk_accelerator_parse("e", &_ngg_tmp_144_accelkey, &_ngg_tmp_146_accelmods);

	gtk_widget_add_accelerator((GtkWidget *) this->mni_tools_eraser, "activate", this->accgrp, _ngg_tmp_144_accelkey, _ngg_tmp_146_accelmods, GTK_ACCEL_VISIBLE);
	unsigned int _ngg_tmp_148_accelkey = 0u;
	GdkModifierType _ngg_tmp_150_accelmods = (GdkModifierType) 0;
	gtk_accelerator_parse("p", &_ngg_tmp_148_accelkey, &_ngg_tmp_150_accelmods);

	gtk_widget_add_accelerator((GtkWidget *) this->mni_tools_eyedropper, "activate", this->accgrp, _ngg_tmp_148_accelkey, _ngg_tmp_150_accelmods, GTK_ACCEL_VISIBLE);
	unsigned int _ngg_tmp_152_accelkey = 0u;
	GdkModifierType _ngg_tmp_154_accelmods = (GdkModifierType) 0;
	gtk_accelerator_parse("f", &_ngg_tmp_152_accelkey, &_ngg_tmp_154_accelmods);

	gtk_widget_add_accelerator((GtkWidget *) this->mni_tools_floodfill, "activate", this->accgrp, _ngg_tmp_152_accelkey, _ngg_tmp_154_accelmods, GTK_ACCEL_VISIBLE);
	unsigned int _ngg_tmp_156_accelkey = 0u;
	GdkModifierType _ngg_tmp_158_accelmods = (GdkModifierType) 0;
	gtk_accelerator_parse("n", &_ngg_tmp_156_accelkey, &_ngg_tmp_158_accelmods);

	gtk_widget_add_accelerator((GtkWidget *) this->mni_tools_pencil, "activate", this->accgrp, _ngg_tmp_156_accelkey, _ngg_tmp_158_accelmods, GTK_ACCEL_VISIBLE);
	unsigned int _ngg_tmp_160_accelkey = 0u;
	GdkModifierType _ngg_tmp_162_accelmods = (GdkModifierType) 0;
	gtk_accelerator_parse("bracketleft", &_ngg_tmp_160_accelkey, &_ngg_tmp_162_accelmods);

	gtk_widget_add_accelerator((GtkWidget *) this->mni_tools_bminus, "activate", this->accgrp, _ngg_tmp_160_accelkey, _ngg_tmp_162_accelmods, GTK_ACCEL_VISIBLE);
	unsigned int _ngg_tmp_164_accelkey = 0u;
	GdkModifierType _ngg_tmp_166_accelmods = (GdkModifierType) 0;
	gtk_accelerator_parse("bracketright", &_ngg_tmp_164_accelkey, &_ngg_tmp_166_accelmods);

	gtk_widget_add_accelerator((GtkWidget *) this->mni_tools_bplus, "activate", this->accgrp, _ngg_tmp_164_accelkey, _ngg_tmp_166_accelmods, GTK_ACCEL_VISIBLE);

	GtkMenu *mnu_help_topics = (GtkMenu *) gtk_menu_new();
	gtk_menu_item_set_submenu(this->mni_help_topics, (GtkWidget *) mnu_help_topics);
	for(_ngg_tmp_3 = 0u; _ngg_tmp_3 < (sizeof helpitems / sizeof helpitems[0]); _ngg_tmp_3 += (1u)) {
		helpitem = helpitems[_ngg_tmp_3];
		HelpMenuItem *mni = (HelpMenuItem *) malloc(sizeof(HelpMenuItem));
		if(mni == NULL) {
			perror(NULL);
			exit(EXIT_FAILURE);
		}

		help_menu_item_construct(mni, helpitem.title, helpitem.message);
		GtkMenuItem *_tmp_34 = help_menu_item_get_native_widget(mni);
		gtk_menu_shell_append((GtkMenuShell *) mnu_help_topics, (GtkWidget *) _tmp_34);
	}

	gtk_widget_show_all((GtkWidget *) mnu_help_topics);

	gtk_radio_button_join_group(this->btn_bglayer, this->btn_fglayer);

	gtk_radio_button_join_group(this->btn_eraser, this->btn_pencil);
	gtk_radio_button_join_group(this->btn_brush, this->btn_pencil);
	gtk_radio_button_join_group(this->btn_eyedropper, this->btn_pencil);
	gtk_radio_button_join_group(this->btn_floodfill, this->btn_pencil);
	gtk_radio_button_join_group(this->btn_pan, this->btn_pencil);

	gtk_radio_button_join_group(this->rad_scatter_type_circle, this->rad_scatter_type_none);
	gtk_radio_button_join_group(this->rad_scatter_type_square, this->rad_scatter_type_none);

	gtk_spin_button_set_range(this->spn_brushsiz, 0, 1000);
	gtk_spin_button_set_increments(this->spn_brushsiz, 1, 4);

	const char * bengarr[4] = {"Circle 1", "Circle 2", "Circle 1 Noise", "Rand. Square"};
	for(_ngg_tmp_4 = 0u; _ngg_tmp_4 < (sizeof bengarr / sizeof bengarr[0]); _ngg_tmp_4 += (1u)) {
		beng = bengarr[_ngg_tmp_4];
		gtk_combo_box_text_append(this->cbo_brush_engine, beng, beng);
	}

	entry_slider_set_range(this->sldr_brush_aaradius_circle1, 1, 2);
	entry_slider_set_increments(this->sldr_brush_aaradius_circle1, 0.25, 0.25);

	entry_slider_set_range(this->sldr_brush_scatter_radius, 0.5, 16);
	entry_slider_set_range(this->sldr_brush_scatter_density, 0.1, 4);
	entry_slider_set_increments(this->sldr_brush_scatter_density, 0.01, 0.1);

	entry_slider_set_range(this->sldr_color_hue, 0, 360);
	entry_slider_set_digits(this->sldr_color_hue, 1);

	entry_slider_set_range(this->sldr_color_sat, 0, 100);
	entry_slider_set_digits(this->sldr_color_sat, 1);

	entry_slider_set_range(this->sldr_color_lit, 0, 100);
	entry_slider_set_digits(this->sldr_color_lit, 1);

	myapp_reserve_cairo_surface(this, DEFWIDTH_CAIRO, DEFHEIGHT_CAIRO);

	int _tmp_34 = imax2(DEFWIDTH_DOC, MINWIDTH_MWND);
	int _tmp_35 = imax2(DEFHEIGHT_DOC, MINHEIGHT_MWND);
	gtk_widget_set_size_request((GtkWidget *) this->wnd, _tmp_34, _tmp_35);
	gtk_window_set_default_size(this->wnd, DEFWIDTH_MWND, DEFHEIGHT_MWND);

	gtk_widget_show((GtkWidget *) this->wnd);

	gtk_widget_add_events((GtkWidget *) this->da, (((GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK) | GDK_POINTER_MOTION_MASK) | GDK_SCROLL_MASK) | GDK_TOUCH_MASK);

	gdk_window_set_event_compression(gtk_widget_get_window((GtkWidget *) this->da), false);

	g_signal_connect((GtkWidget *) this->da, "event", G_CALLBACK(on_da_event), this);
	g_signal_connect((GtkWidget *) this->da, "draw", G_CALLBACK(on_da_paint), this);

	ImageDocument *initdoc = NULL;

	if(infile_path) {
		const char * pathnn;
		pathnn = (const char *) infile_path;
		initdoc = read_image_document_from_xcf(pathnn);
		if(!initdoc) {
			myapp_handle_fileio_err(this, VARA_FILE_I_O_ERROR_OTHER, false);
		}
	}

	if(!initdoc) {
		ImageDocument *_tmp_15 = (ImageDocument *) malloc(sizeof(ImageDocument));
		if(_tmp_15 == NULL) {
			perror(NULL);
			exit(EXIT_FAILURE);
		}

		image_document_construct(_tmp_15, this->doc->width, this->doc->height, dpbak, true);
		initdoc = _tmp_15;
	}

	assert(initdoc);
	myapp_set_document(this, initdoc);
}

_Bool myapp_can_zoom_in(myapp *this)
{
	return true;
}

_Bool myapp_can_zoom_out(myapp *this)
{
	return this->doc->vpzoom >= (2 * ZOOMSTEP);
}

_Bool myapp_prompt_close_document(myapp *this)
{
	if(!this->doc) {
		return true;
	}

	_Bool _ngg_tmp_167;
	GtkDialog *dlg = (GtkDialog *) gtk_message_dialog_new(this->wnd, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, "%s", "Are you sure you want to close the document?");

	int _ngg_tmp_14 = 0;
	int res = gtk_dialog_run(dlg);
	gtk_widget_destroy((GtkWidget *) dlg);
	_ngg_tmp_14 = res;
	_ngg_tmp_167 = GTK_RESPONSE_YES == _ngg_tmp_14;
	return _ngg_tmp_167;
}

void myapp_reflect_brush_status(myapp *this)
{
	this->disable_brush_preview = true;

	switch(this->doc->drawparams.brushparams.type) {
	case BRUSHTYPE_CIRCLE1:
	{
		gtk_combo_box_set_active_id((GtkComboBox *) this->cbo_brush_engine, "Circle 1");
		break;
	}
	case BRUSHTYPE_CIRCLE1NOISE:
	{
		gtk_combo_box_set_active_id((GtkComboBox *) this->cbo_brush_engine, "Circle 1 Noise");
		break;
	}
	case BRUSHTYPE_CIRCLE2:
	{
		gtk_combo_box_set_active_id((GtkComboBox *) this->cbo_brush_engine, "Circle 2");
		break;
	}
	case BRUSHTYPE_RANDSQUARE:
	{
		gtk_combo_box_set_active_id((GtkComboBox *) this->cbo_brush_engine, "Rand. Square");
		break;
	}
	}

	gtk_toggle_button_set_active((GtkToggleButton *) this->chk_pressure, this->doc->drawparams.brushparams.pressure_size);

	switch(this->doc->drawparams.brushparams.scatter_type) {
	case SCATTERTYPE_NONE:
	{
		gtk_toggle_button_set_active((GtkToggleButton *) this->rad_scatter_type_none, true);
		break;
	}
	case SCATTERTYPE_CIRCLE:
	{
		gtk_toggle_button_set_active((GtkToggleButton *) this->rad_scatter_type_circle, true);
		break;
	}
	case SCATTERTYPE_SQUARE:
	{
		gtk_toggle_button_set_active((GtkToggleButton *) this->rad_scatter_type_square, true);
		break;
	}
	default:
	{
		assert(false); /* ui.ngg:862 */
		break;
	}
	}

	gtk_spin_button_set_value(this->spn_brushsiz, this->doc->drawparams.brushparams.siz);

	entry_slider_set_value_by_code(this->sldr_brush_opacity, this->doc->drawparams.brushparams.opacity);
	entry_slider_set_value_by_code(this->sldr_brush_softness, this->doc->drawparams.brushparams.softness);
	entry_slider_set_value_by_code(this->sldr_brush_aaradius_circle1, this->doc->drawparams.brushparams.aaradius_circle1);
	entry_slider_set_value_by_code(this->sldr_brush_scatter_radius, this->doc->drawparams.brushparams.scatter_radius);
	entry_slider_set_value_by_code(this->sldr_brush_scatter_density, this->doc->drawparams.brushparams.scatter_density);

	gtk_toggle_button_set_active((GtkToggleButton *) this->chk_scatter_take_pressure, this->doc->drawparams.brushparams.scatter_take_pressure);

	this->disable_brush_preview = false;

	myapp_repreview_brush(this);
}

void myapp_reflect_document_state(myapp *this)
{
	myapp_reflect_tool_status(this);

	myapp_set_canvas_cursor_for_active_tool(this);

	entry_slider_set_value_by_code(this->sldr_stroke_smoothness, this->doc->stroke_smoothness);
	gtk_toggle_button_set_active((GtkToggleButton *) this->chk_subpixel_when_zoomed, this->doc->subpixel_when_zoomed);

	myapp_reflect_brush_status(this);

	myapp_reflect_color_status(this);

	myapp_update_zoom_controls(this);

	myapp_reflect_layer_status(this);

	gtk_toggle_button_set_active((GtkToggleButton *) this->chk_scratch, this->doc->scratchmode);

	myapp_update_history_controls(this);
}

void myapp_reflect_color_status(myapp *this)
{
	Pixel fgcolor_srgb = linearpixel2srgb(this->doc->drawparams.fgcolor);

	float r = fgcolor_srgb.rgb[0];
	float g = fgcolor_srgb.rgb[1];
	float b = fgcolor_srgb.rgb[2];

	float _tmp_1 = fgcolor_srgb.rgb[3];
		GdkRGBA rgba = (GdkRGBA) ((GdkRGBA){ r, g, b, _tmp_1});
	gtk_color_chooser_set_rgba((GtkColorChooser *) this->btn_color, (GdkRGBA *) (&rgba));

	if(!this->color_being_set_by_hsl) {
		myapp_reflect_color_status_in_hsl(this, r, g, b);
	}
}

void myapp_reflect_color_status_in_hsl(myapp *this, double r, double g, double b)
{
	double cmin = dmin3(r, g, b);
	double cmax = dmax3(r, g, b);

	double cdiff = cmax - cmin;

	_Bool r_is_max = (r >= g) && (r >= b);
	_Bool g_is_max = (g >= r) && (g >= b);
	_Bool b_is_max = (b >= r) && (b >= g);

	double hue = 0.0;

	if(cdiff == 0) {
	} else if(r_is_max) {
		hue = ((g - b) / cdiff) / 6;
	} else if(g_is_max) {
		hue = (1.0 / 3) + (((b - r) / cdiff) / 6);
	} else if(b_is_max) {
		hue = (2.0 / 3) + (((r - g) / cdiff) / 6);
	}

	if(hue < 0) {
		hue = 1 + hue;
	}

	assert(hue >= 0 && hue <= 1); /* ui.ngg:942 */

	entry_slider_set_value(this->sldr_color_hue, hue * 360);

	entry_slider_set_value(this->sldr_color_sat, cdiff * 100);

	double lit = (cmin + cmax) / 2;
	entry_slider_set_value(this->sldr_color_lit, lit * 100);
}

void myapp_reflect_layer_status(myapp *this)
{
	_Bool can_switch_layer = image_document_can_switch_layer(this->doc);
	gtk_widget_set_sensitive((GtkWidget *) this->btn_fglayer, this->doc->in_bg_fg_mode && can_switch_layer);
	gtk_widget_set_sensitive((GtkWidget *) this->btn_bglayer, this->doc->in_bg_fg_mode && can_switch_layer);
	gtk_widget_set_sensitive((GtkWidget *) this->lst_layers, can_switch_layer);
	gtk_widget_set_sensitive((GtkWidget *) this->chk_bg_visible, this->doc->in_bg_fg_mode);
	gtk_widget_set_sensitive((GtkWidget *) this->chk_fg_visible, this->doc->in_bg_fg_mode);

	if(image_document_is_curlayer_fg(this->doc) && (!gtk_toggle_button_get_active((GtkToggleButton *) this->btn_fglayer))) {
		gtk_toggle_button_set_active((GtkToggleButton *) this->btn_fglayer, true);
	} else if(image_document_is_curlayer_bg(this->doc) && (!gtk_toggle_button_get_active((GtkToggleButton *) this->btn_bglayer))) {
		gtk_toggle_button_set_active((GtkToggleButton *) this->btn_bglayer, true);
	}

	_Bool _tmp_1 = image_document_has_bglayer(this->doc) && image_document_get_bglayer_must(this->doc)->visible;
	gtk_toggle_button_set_active((GtkToggleButton *) this->chk_bg_visible, _tmp_1);

	_Bool _tmp_2 = image_document_has_fglayer(this->doc) && image_document_get_fglayer_must(this->doc)->visible;
	gtk_toggle_button_set_active((GtkToggleButton *) this->chk_fg_visible, _tmp_2);

	if(this->doc->layerstack_version != this->layerstack_version) {
		int idxidx;
		this->updating_lst_layers = true;

		GList *chld;
		GList *chldrn = gtk_container_get_children((GtkContainer *) this->lst_layers);
		chld = chldrn;
		while(chld) {
			assert(chld->data);
			gtk_widget_destroy((GtkWidget *) (chld->data));
			chld = (GList *) chld->next;
		}

		for(idxidx = intvector_get_count(this->doc->layerstack) - 1; idxidx >= 0; idxidx -= 1) {
			int layeridx = intvector_get_item(this->doc->layerstack, idxidx);

			Layer *layer = image_document_get_layer_must(this->doc, layeridx);
			GtkLabel *lbl = (GtkLabel *) gtk_label_new(NULL);
			gtk_label_set_label(lbl, layer->name);
			gtk_label_set_xalign(lbl, 0);
			gtk_widget_set_visible((GtkWidget *) lbl, true);
			gtk_container_add(GTK_CONTAINER((GtkWidget *) this->lst_layers), GTK_WIDGET((GtkWidget *) lbl));
		}

		this->layerstack_version = this->doc->layerstack_version;

		this->updating_lst_layers = false;
	}

	int _tmp_3 = (intvector_get_count(this->doc->layerstack) - 1) - image_document_get_curlayeridxidx(this->doc);
	int _ngg_tmp_13 = 0;
	GtkListBoxRow *row = NULL;
	row = gtk_list_box_get_selected_row(this->lst_layers);

	int _ngg_tmp_169__tmp_1 = 0;
	if(row) {
				_ngg_tmp_169__tmp_1 = (int) (gtk_list_box_row_get_index(row));
	} else {
		_ngg_tmp_169__tmp_1 = -1;
	}

	_ngg_tmp_13 = _ngg_tmp_169__tmp_1;
	if(_tmp_3 != _ngg_tmp_13) {
		GtkListBoxRow *row = gtk_list_box_get_row_at_index(this->lst_layers, _tmp_3);
		assert(row);
		gtk_list_box_select_row(this->lst_layers, row);
	}

	_Bool _tmp_4 = image_document_can_create_layer(this->doc);
	gtk_widget_set_sensitive((GtkWidget *) this->btn_layer_new, _tmp_4);
	_Bool _tmp_5 = image_document_can_move_layer_up(this->doc);
	gtk_widget_set_sensitive((GtkWidget *) this->btn_layer_move_up, _tmp_5);
	_Bool _tmp_6 = image_document_can_move_layer_down(this->doc);
	gtk_widget_set_sensitive((GtkWidget *) this->btn_layer_move_down, _tmp_6);
	_Bool _tmp_7 = image_document_can_rename_layer(this->doc);
	gtk_widget_set_sensitive((GtkWidget *) this->btn_layer_rename, _tmp_7);
	_Bool _tmp_8 = image_document_can_delete_layer(this->doc);
	gtk_widget_set_sensitive((GtkWidget *) this->btn_layer_delete, _tmp_8);

	entry_slider_set_value(this->sldr_layer_opacity, image_document_get_curlayer(this->doc)->alpha);
}

void myapp_reflect_tool_status(myapp *this)
{
	switch(this->doc->drawparams.active_tool) {
	case TOOL_BRUSH:
	{
		if(this->doc->drawparams.erase) {
			gtk_toggle_button_set_active((GtkToggleButton *) this->btn_eraser, true);
		} else {
			gtk_toggle_button_set_active((GtkToggleButton *) this->btn_brush, true);
		}
		break;
	}
	case TOOL_PENCIL:
	{
		gtk_toggle_button_set_active((GtkToggleButton *) this->btn_pencil, true);
		break;
	}
	case TOOL_EYEDROPPER:
	{
		gtk_toggle_button_set_active((GtkToggleButton *) this->btn_eyedropper, true);
		break;
	}
	case TOOL_FLOODFILL:
	{
		gtk_toggle_button_set_active((GtkToggleButton *) this->btn_floodfill, true);
		break;
	}
	case TOOL_PAN:
	{
		gtk_toggle_button_set_active((GtkToggleButton *) this->btn_pan, true);
		break;
	}
	}
}

void myapp_set_canvas_cursor(myapp *this, const char * name)
{
	GdkWindow *gdkwin = gtk_widget_get_window((GtkWidget *) this->da);

	gdk_window_set_cursor(gdkwin, gdk_cursor_new_from_name(gdk_window_get_display(gdkwin), name));
}

void myapp_set_canvas_cursor_for_active_tool(myapp *this)
{
	if(clopts.static_cursor) {
		return;
	}

	_Bool pick_circle = false;

	switch(this->doc->drawparams.active_tool) {
	case TOOL_BRUSH:
	{
		pick_circle = true;
		break;
	}
	case TOOL_PENCIL:
	{
		myapp_set_canvas_cursor(this, "default");
		this->curcursor_is_circle = false;
		break;
	}
	case TOOL_EYEDROPPER:
	{
		myapp_set_canvas_cursor(this, "default");
		this->curcursor_is_circle = false;
		break;
	}
	case TOOL_FLOODFILL:
	{
		myapp_set_canvas_cursor(this, "pointer");
		this->curcursor_is_circle = false;
		break;
	}
	case TOOL_PAN:
	{
		myapp_set_canvas_cursor(this, "grab");
		this->curcursor_is_circle = false;
		break;
	}
	}

	if(pick_circle) {
		GdkWindow *gdkwin = gtk_widget_get_window((GtkWidget *) this->da);
		GdkDisplay *gdkdisp = gdk_window_get_display(gdkwin);

		unsigned int maxw = 0u;
		unsigned int maxh = maxw;
		gdk_display_get_maximal_cursor_size(gdkdisp, &maxw, &maxh);
		int maxsiz = (int) umin2(maxw, maxh);

		if(maxsiz <= 0) {
			fprintf(stderr, "warning: gdk_display_get_maximal_cursor_size() returned <= 0: %d\n", maxsiz);

			unsigned int defsiz = gdk_display_get_default_cursor_size(gdkdisp);

			if(defsiz > (0u)) {
				maxsiz = (int) defsiz;
			} else {
				fprintf(stderr, "warning: gdk_display_get_default_cursor_size() returned <= 0: %d\n", defsiz);

				return;
			}
		}

		assert(maxsiz > 0); /* ui.ngg:1103 */

		int minsiz = 4;

		int siz = this->doc->drawparams.brushparams.siz;
		if(siz > maxsiz) {
			siz = maxsiz;
		} else if(siz < minsiz) {
			siz = minsiz;
		}

		if(this->curcursor_is_circle && (siz == this->curcursorsiz)) {
			return;
		} else {
			this->curcursorsiz = siz;
		}

		Image *img = (Image *) malloc(sizeof(Image));
		if(img == NULL) {
			perror(NULL);
			exit(EXIT_FAILURE);
		}

		image_construct(img, siz, siz, 255);
		image_fill(img, LINEAR_PIXEL_TRANSP);

		int aardius = 1;
		int mid = siz / 2;
		int rad = mid;

		nan_img_draw_circle(img, mid, mid, rad, aardius);

		cairo_surface_t *isurf = cairo_image_surface_create(CAIRO_FORMAT_ARGB32, siz, siz);
		copy_image_region_to_cairo_surface(img, isurf, image_get_region(img));
		gdk_window_set_cursor(gdkwin, gdk_cursor_new_from_surface(gdkdisp, isurf, mid, mid));

		this->curcursor_is_circle = true;
		if(img) {
			image_destruct(img);
			free(img);
		}

		if(isurf) {
			cairo_surface_destroy(isurf);
		}
	}
}

void myapp_set_document(myapp *this, ImageDocument *newdoc)
{
	if(layer_owning_vector_get_count(newdoc->layers) < 1) {
		fprintf(stderr, "bug: ImageDocument passed to set-document has zero layers");
		return;
	}

	ImageDocument *_ngg_tmp_6 = newdoc;
	if(this->doc) {
		image_document_destruct(this->doc);
		free(this->doc);
	}

	this->doc = _ngg_tmp_6;
	myapp_after_set_document(this);
}

void myapp_after_set_document(myapp *this)
{
	int vpw = imax2(gtk_widget_get_allocated_width((GtkWidget *) this->da), 1);
	int vph = imax2(gtk_widget_get_allocated_height((GtkWidget *) this->da), 1);
	image_document_viewport_set_size(this->doc, vpw, vph);

	image_document_viewport_align_center(this->doc);

	image_document_set_history_changed_callback(this->doc, (void (*)(void *userdata)) myapp_update_history_controls, this);

	this->layerstack_version = -1;

	myapp_reflect_document_state(this);

	myapp_drawframe_noskip(this);
}

void myapp_on_btn_color_set(GtkColorButton *widget, void *user_data)
{
	GdkRGBA _ngg_tmp_170;
	GdkRGBA _ngg_tmp_172_rgba;
	gtk_color_chooser_get_rgba((GtkColorChooser *) widget, &_ngg_tmp_172_rgba);
	_ngg_tmp_170 = _ngg_tmp_172_rgba;
	GdkRGBA rgba = _ngg_tmp_170;
	((myapp *) user_data)->doc->drawparams.fgcolor = srgbpixel2linear((Pixel) { {rgba.red, rgba.green, rgba.blue, 1} });
}

void myapp_on_btn_layer_delete_clicked(GtkToolButton *widget, void *user_data)
{
	image_document_delete_layer(((myapp *) user_data)->doc);
	myapp_reflect_layer_status(((myapp *) user_data));
	myapp_drawframe_noskip(((myapp *) user_data));
}

void myapp_on_btn_layer_move_down_clicked(GtkToolButton *widget, void *user_data)
{
	image_document_move_layer_down(((myapp *) user_data)->doc);
	myapp_reflect_layer_status(((myapp *) user_data));
	myapp_drawframe_noskip(((myapp *) user_data));
}

void myapp_on_btn_layer_move_up_clicked(GtkToolButton *widget, void *user_data)
{
	image_document_move_layer_up(((myapp *) user_data)->doc);
	myapp_reflect_layer_status(((myapp *) user_data));
	myapp_drawframe_noskip(((myapp *) user_data));
}

void myapp_on_btn_layer_new_clicked(GtkToolButton *widget, void *user_data)
{
	InputDialog *ndlg = (InputDialog *) malloc(sizeof(InputDialog));
	if(ndlg == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	input_dialog_construct(ndlg, ((myapp *) user_data)->wnd, "New Layer", "Name: ");
	InputDialogResponse *resp = input_dialog_run(ndlg);

	if(resp->ok) {
		assert(resp->name);
		image_document_create_layer_and_switch(((myapp *) user_data)->doc, resp->name, LINEAR_PIXEL_TRANSP);
		myapp_reflect_layer_status(((myapp *) user_data));
	}

	if(ndlg) {
		input_dialog_destruct(ndlg);
		free(ndlg);
	}

	if(resp) {
		input_dialog_response_destruct(resp);
		free(resp);
	}
}

void myapp_on_btn_layer_rename_clicked(GtkToolButton *widget, void *user_data)
{
	InputDialog *ndlg = (InputDialog *) malloc(sizeof(InputDialog));
	if(ndlg == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	input_dialog_construct(ndlg, ((myapp *) user_data)->wnd, "Rename Layer", "Name: ");
	InputDialogResponse *resp = input_dialog_run(ndlg);

	if(resp->ok) {
		assert(resp->name);
		image_document_rename_layer(((myapp *) user_data)->doc, resp->name);
		myapp_reflect_layer_status(((myapp *) user_data));
	}

	if(ndlg) {
		input_dialog_destruct(ndlg);
		free(ndlg);
	}

	if(resp) {
		input_dialog_response_destruct(resp);
		free(resp);
	}
}

void myapp_on_btn_more_layers_clicked(GtkButton *widget, void *user_data)
{
	gtk_toggle_button_set_active((GtkToggleButton *) ((myapp *) user_data)->chk_advanced, true);
	int _tmp_1 = gtk_notebook_page_num(((myapp *) user_data)->nbk_advanced, (GtkWidget *) ((myapp *) user_data)->box_layers);
	gtk_notebook_set_current_page(((myapp *) user_data)->nbk_advanced, _tmp_1);
}

void myapp_on_quickpalette_colorset(QuickPalette *widget, LinearPixel eventcolor_linear, void *user_data)
{
	((myapp *) user_data)->doc->drawparams.fgcolor = eventcolor_linear;
	myapp_reflect_color_status(((myapp *) user_data));
}

void myapp_on_spn_brushsiz_changed(GtkSpinButton *widget, void *user_data)
{
	((myapp *) user_data)->doc->drawparams.brushparams.siz = (int) gtk_spin_button_get_value(widget);
	myapp_update_brush_size_view(((myapp *) user_data));
}

void myapp_on_btn_tool_x_toggled(GtkCheckButton *widget, void *user_data)
{
	if(!gtk_toggle_button_get_active((GtkToggleButton *) widget)) {
		return;
	}

	if(widget == ((GtkCheckButton *) ((myapp *) user_data)->btn_brush)) {
		myapp_pick_tool(((myapp *) user_data), TOOL_BRUSH, false);
	} else if(widget == ((GtkCheckButton *) ((myapp *) user_data)->btn_eraser)) {
		myapp_pick_tool(((myapp *) user_data), TOOL_BRUSH, true);
	} else if(widget == ((GtkCheckButton *) ((myapp *) user_data)->btn_pencil)) {
		myapp_pick_tool(((myapp *) user_data), TOOL_PENCIL, false);
	} else if(widget == ((GtkCheckButton *) ((myapp *) user_data)->btn_eyedropper)) {
		myapp_pick_tool(((myapp *) user_data), TOOL_EYEDROPPER, false);
	} else if(widget == ((GtkCheckButton *) ((myapp *) user_data)->btn_floodfill)) {
		myapp_pick_tool(((myapp *) user_data), TOOL_FLOODFILL, false);
	} else if(widget == ((GtkCheckButton *) ((myapp *) user_data)->btn_pan)) {
		myapp_pick_tool(((myapp *) user_data), TOOL_PAN, false);
	}
}

void myapp_on_cbo_brush_engine_changed(GtkComboBox *widget, void *user_data)
{
	const char * id = gtk_combo_box_get_active_id(widget);
	_Bool iscircle = false;
	_Bool iscircle1 = iscircle;

	if(0 == strcmp(id, "Circle 1")) {
		((myapp *) user_data)->doc->drawparams.brushparams.type = BRUSHTYPE_CIRCLE1;
		iscircle = true;
		iscircle1 = true;
	} else if(0 == strcmp(id, "Circle 1 Noise")) {
		((myapp *) user_data)->doc->drawparams.brushparams.type = BRUSHTYPE_CIRCLE1NOISE;
		iscircle = true;
	} else if(0 == strcmp(id, "Circle 2")) {
		((myapp *) user_data)->doc->drawparams.brushparams.type = BRUSHTYPE_CIRCLE2;
		iscircle = true;
	} else if(0 == strcmp(id, "Rand. Square")) {
		((myapp *) user_data)->doc->drawparams.brushparams.type = BRUSHTYPE_RANDSQUARE;
	}

	entry_slider_set_sensitive(((myapp *) user_data)->sldr_brush_softness, iscircle);
	entry_slider_set_sensitive(((myapp *) user_data)->sldr_brush_aaradius_circle1, iscircle1);
	myapp_repreview_brush(((myapp *) user_data));
}

void myapp_on_mni_file_open_activate(GtkMenuItem *widget, void *user_data)
{
	if(!myapp_prompt_close_document(((myapp *) user_data))) {
		return;
	}

	char * fnam = myapp_prompt_for_open_filename(((myapp *) user_data));
	if(fnam) {
		char * fnamnn;
		fnamnn = (char *) fnam;
		ImageDocument *opdoc = read_image_document_from_xcf(fnamnn);
		if(opdoc) {
			ImageDocument *opdocnn;
			opdocnn = (ImageDocument *) opdoc;
			myapp_set_document(((myapp *) user_data), opdocnn);
		} else {
			myapp_handle_fileio_err(((myapp *) user_data), VARA_FILE_I_O_ERROR_OTHER, false);
		}
	}

	if(fnam) {
		free(fnam);
	}
}

void myapp_on_mni_file_save_as_activate(GtkMenuItem *widget, void *user_data)
{
	char * fnam = myapp_prompt_for_save_as_filename(((myapp *) user_data));
	if(fnam) {
		char * fnamnn;
		fnamnn = (char *) fnam;
		char * fnamext = append_xcf_if_needed_and_possible(fnamnn);
		int err = write_xcf_from_image_document(fnamext, ((myapp *) user_data)->doc);
		if(err) {
			myapp_handle_fileio_err(((myapp *) user_data), VARA_FILE_I_O_ERROR_OTHER, true);
		}

		if(fnamext) {
			free(fnamext);
		}
	}

	if(fnam) {
		free(fnam);
	}
}

void myapp_on_mni_file_quit_activate(GtkMenuItem *widget, void *user_data)
{
	gtk_window_close(((myapp *) user_data)->wnd);
}

void myapp_on_mni_fill_bgcolor_activate(GtkMenuItem *widget, void *user_data)
{
	image_document_fill_layer_with_bgcolor(((myapp *) user_data)->doc);
	myapp_drawframe_noskip(((myapp *) user_data));
}

void myapp_on_mni_fill_fgcolor_activate(GtkMenuItem *widget, void *user_data)
{
	image_document_fill_layer_with_fgcolor(((myapp *) user_data)->doc);
	myapp_drawframe_noskip(((myapp *) user_data));
}

void myapp_on_mni_tool_x_toggled(GtkMenuItem *widget, void *user_data)
{
	if(widget == ((myapp *) user_data)->mni_tools_brush) {
		myapp_pick_tool(((myapp *) user_data), TOOL_BRUSH, false);
	} else if(widget == ((myapp *) user_data)->mni_tools_eraser) {
		myapp_pick_tool(((myapp *) user_data), TOOL_BRUSH, true);
	} else if(widget == ((myapp *) user_data)->mni_tools_pencil) {
		myapp_pick_tool(((myapp *) user_data), TOOL_PENCIL, false);
	} else if(widget == ((myapp *) user_data)->mni_tools_eyedropper) {
		myapp_pick_tool(((myapp *) user_data), TOOL_EYEDROPPER, false);
	} else if(widget == ((myapp *) user_data)->mni_tools_floodfill) {
		myapp_pick_tool(((myapp *) user_data), TOOL_FLOODFILL, false);
	} else if(widget == ((myapp *) user_data)->mni_tools_pan) {
		myapp_pick_tool(((myapp *) user_data), TOOL_PAN, false);
	}

	myapp_reflect_tool_status(((myapp *) user_data));
}

void myapp_on_mni_tools_bplus_activate(GtkMenuItem *widget, void *user_data)
{
	gtk_spin_button_spin(((myapp *) user_data)->spn_brushsiz, GTK_SPIN_PAGE_FORWARD, 0);
}

void myapp_on_mni_tools_bminus_activate(GtkMenuItem *widget, void *user_data)
{
	gtk_spin_button_spin(((myapp *) user_data)->spn_brushsiz, GTK_SPIN_PAGE_BACKWARD, 0);
}

void myapp_on_btn_prebrush_clicked(GtkButton *widget, void *user_data)
{
	if(widget == ((myapp *) user_data)->btn_prebrush_ballpoint) {
		((myapp *) user_data)->doc->drawparams.brushparams = prebrush_ballpoint();
	} else if(widget == ((myapp *) user_data)->btn_prebrush_charcoal) {
		((myapp *) user_data)->doc->drawparams.brushparams = prebrush_charcoal();
	} else if(widget == ((myapp *) user_data)->btn_prebrush_crayon) {
		((myapp *) user_data)->doc->drawparams.brushparams = prebrush_crayon();
	} else if(widget == ((myapp *) user_data)->btn_prebrush_pencil) {
		((myapp *) user_data)->doc->drawparams.brushparams = prebrush_pencil();
	} else if(widget == ((myapp *) user_data)->btn_prebrush_round) {
		((myapp *) user_data)->doc->drawparams.brushparams = prebrush_round();
	} else if(widget == ((myapp *) user_data)->btn_prebrush_round_pressure_size) {
		((myapp *) user_data)->doc->drawparams.brushparams = prebrush_round_pressure_size();
	} else if(widget == ((myapp *) user_data)->btn_prebrush_soft_round) {
		((myapp *) user_data)->doc->drawparams.brushparams = prebrush_soft_round();
	} else {
		assert(false); /* ui.ngg:1369 */
	}

	if(((myapp *) user_data)->doc->drawparams.active_tool != TOOL_BRUSH) {
		gtk_widget_activate((GtkWidget *) ((myapp *) user_data)->btn_brush);
	}

	myapp_reflect_brush_status(((myapp *) user_data));
}

void myapp_on_hsl_sliders_changed(EntrySlider *widget, void *user_data)
{
	int i;
	if(!((myapp *) user_data)->doc) {
		return;
	}

	double h = entry_slider_get_value(((myapp *) user_data)->sldr_color_hue) / 360;
	double s = entry_slider_get_value(((myapp *) user_data)->sldr_color_sat) / 100;
	double l = entry_slider_get_value(((myapp *) user_data)->sldr_color_lit) / 100;

	Pixel px = pixel_default();

	double huepart = (((int) (h * 360)) % 60) / 60.0;
	double huepos = h * 6;

	if(huepos < 1) {
		px = (Pixel) { {1, huepart, 0, 1} };
	} else if(huepos < 2) {
		px = (Pixel) { {1 - huepart, 1, 0, 1} };
	} else if(huepos < 3) {
		px = (Pixel) { {0, 1, huepart, 1} };
	} else if(huepos < 4) {
		px = (Pixel) { {0, 1 - huepart, 1, 1} };
	} else if(huepos < 5) {
		px = (Pixel) { {huepart, 0, 1, 1} };
	} else {
		px = (Pixel) { {1, 0, 1 - huepart, 1} };
	}

	for(i = 0; i < 3; i += 1) {
		px.rgb[i] += ((0.5 - px.rgb[i]) * (1 - s));
	}

	if(l <= 0.5) {
		for(i = 0; i < 3; i += 1) {
			px.rgb[i] -= (px.rgb[i] * (1 - (l / 0.5)));
		}
	} else {
		for(i = 0; i < 3; i += 1) {
			px.rgb[i] += ((1 - px.rgb[i]) * ((l - 0.5) / 0.5));
		}
	}

	((myapp *) user_data)->doc->drawparams.fgcolor = srgbpixel2linear(px);

	((myapp *) user_data)->color_being_set_by_hsl = true;
	myapp_reflect_color_status(((myapp *) user_data));
	((myapp *) user_data)->color_being_set_by_hsl = false;
}

void myapp_on_lst_layers_row_selected(GtkListBox *widget, GtkListBoxRow *row, void *user_data)
{
	if(((myapp *) user_data)->updating_lst_layers) {
		return;
	}

		int stackidx = (intvector_get_count(((myapp *) user_data)->doc->layerstack) - 1) - ((int) (gtk_list_box_row_get_index(row)));

	if(stackidx == ((myapp *) user_data)->doc->curlayeridxidx) {
		return;
	}

	image_document_switch_layer(((myapp *) user_data)->doc, stackidx);
	myapp_reflect_layer_status(((myapp *) user_data));
}

void myapp_on_sldr_layer_opacity_changed(EntrySlider *widget, void *user_data)
{
	image_document_set_curlayer_alpha(((myapp *) user_data)->doc, entry_slider_get_value(widget));
	myapp_drawframe_noskip(((myapp *) user_data));
}

void myapp_on_sldr_stroke_smoothness_changed(EntrySlider *widget, void *user_data)
{
	((myapp *) user_data)->doc->stroke_smoothness = entry_slider_get_value(widget);
}

void myapp_on_chk_advanced_toggled(GtkCheckButton *widget, void *user_data)
{
	_Bool _tmp_1 = gtk_toggle_button_get_active((GtkToggleButton *) widget);
	gtk_widget_set_visible((GtkWidget *) ((myapp *) user_data)->nbk_advanced, _tmp_1);
}

void myapp_on_chk_scatter_take_pressure_toggled(GtkCheckButton *widget, void *user_data)
{
	if(((myapp *) user_data)->doc->drawparams.brushparams.scatter_take_pressure == gtk_toggle_button_get_active((GtkToggleButton *) widget)) {
		return;
	}

	((myapp *) user_data)->doc->drawparams.brushparams.scatter_take_pressure = gtk_toggle_button_get_active((GtkToggleButton *) widget);
	myapp_repreview_brush(((myapp *) user_data));
}

void myapp_on_rad_scatter_type_x_toggled(GtkCheckButton *widget, void *user_data)
{
	if(!((myapp *) user_data)->doc) {
		return;
	}

	if(gtk_toggle_button_get_active((GtkToggleButton *) ((myapp *) user_data)->rad_scatter_type_none)) {
		((myapp *) user_data)->doc->drawparams.brushparams.scatter_type = SCATTERTYPE_NONE;
	} else if(gtk_toggle_button_get_active((GtkToggleButton *) ((myapp *) user_data)->rad_scatter_type_circle)) {
		((myapp *) user_data)->doc->drawparams.brushparams.scatter_type = SCATTERTYPE_CIRCLE;
	} else if(gtk_toggle_button_get_active((GtkToggleButton *) ((myapp *) user_data)->rad_scatter_type_square)) {
		((myapp *) user_data)->doc->drawparams.brushparams.scatter_type = SCATTERTYPE_SQUARE;
	} else {
		assert(false); /* ui.ngg:1473 */
	}

	myapp_repreview_brush(((myapp *) user_data));
}

void myapp_on_chk_scratch_toggled(GtkCheckButton *widget, void *user_data)
{
	if(((myapp *) user_data)->doc->scratchmode == gtk_toggle_button_get_active((GtkToggleButton *) widget)) {
		return;
	}

	image_document_toggle_scratch_mode(((myapp *) user_data)->doc);
	myapp_reflect_document_state(((myapp *) user_data));
	myapp_drawframe_noskip(((myapp *) user_data));
}

void myapp_on_chk_subpixel_when_zoomed_toggled(GtkCheckButton *widget, void *user_data)
{
	((myapp *) user_data)->doc->subpixel_when_zoomed = gtk_toggle_button_get_active((GtkToggleButton *) widget);
}

void myapp_on_chk_pressure_toggled(GtkCheckButton *widget, void *user_data)
{
	((myapp *) user_data)->doc->drawparams.brushparams.pressure_size = gtk_toggle_button_get_active((GtkToggleButton *) widget);
	myapp_repreview_brush(((myapp *) user_data));
}

void myapp_on_btn_xlayer_toggled(GtkCheckButton *widget, void *user_data)
{
	if(!((myapp *) user_data)->doc) {
		return;
	}

	if(intvector_get_count(((myapp *) user_data)->doc->layerstack) <= 2) {
		return;
	}

	if(gtk_toggle_button_get_active((GtkToggleButton *) ((myapp *) user_data)->btn_bglayer) && (!image_document_is_curlayer_bg(((myapp *) user_data)->doc))) {
		image_document_switch_layer_bg(((myapp *) user_data)->doc);
	} else if(gtk_toggle_button_get_active((GtkToggleButton *) ((myapp *) user_data)->btn_fglayer) && (!image_document_is_curlayer_fg(((myapp *) user_data)->doc))) {
		image_document_switch_layer_fg(((myapp *) user_data)->doc);
	}

	myapp_reflect_layer_status(((myapp *) user_data));
}

void myapp_on_btn_clear_layer_clicked(GtkButton *widget, void *user_data)
{
	image_document_clear_layer(((myapp *) user_data)->doc);
	myapp_drawframe_noskip(((myapp *) user_data));
}

void myapp_handle_fileio_err(myapp *this, VaraFileIOError err, _Bool saving)
{
	switch(err) {
	case VARA_FILE_I_O_ERROR_SUCCESS:
	{
		break;
	}
	default:
	{
		const char * _tmp_1 = (saving ? "Error saving file; please try another location and manually adding the file extension (if not done already)." : "Error opening file.");
		GtkDialog *dlg = (GtkDialog *) gtk_message_dialog_new(this->wnd, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp_1);

		int _ngg_tmp_173;
		int res = gtk_dialog_run(dlg);
		gtk_widget_destroy((GtkWidget *) dlg);
		_ngg_tmp_173 = res;
		break;
	}
	}
}

void myapp_on_btn_export_doc_clicked(GtkButton *widget, void *user_data)
{
	char * fnam = myapp_prompt_for_export_filename(((myapp *) user_data));
	if(fnam) {
		char * fnamnn;
		fnamnn = (char *) fnam;
		char * fnamext = append_png_if_needed_and_possible(fnamnn);
		myapp_handle_fileio_err(((myapp *) user_data), image_document_export_document(((myapp *) user_data)->doc, fnamext, false), true);
		if(fnamext) {
			free(fnamext);
		}
	}

	if(fnam) {
		free(fnam);
	}
}

void myapp_on_btn_export_layer_clicked(GtkButton *widget, void *user_data)
{
	char * fnam = myapp_prompt_for_export_filename(((myapp *) user_data));
	if(fnam) {
		char * fnamnn;
		fnamnn = (char *) fnam;
		char * fnamext = append_png_if_needed_and_possible(fnamnn);
		myapp_handle_fileio_err(((myapp *) user_data), image_document_export_layer(((myapp *) user_data)->doc, fnamext, false), true);
		if(fnamext) {
			free(fnamext);
		}
	}

	if(fnam) {
		free(fnam);
	}
}

void myapp_on_btn_undo_clicked(GtkButton *widget, void *user_data)
{
	image_document_undo(((myapp *) user_data)->doc);
	myapp_drawframe_noskip(((myapp *) user_data));
	myapp_reflect_layer_status(((myapp *) user_data));
}

void myapp_on_btn_redo_clicked(GtkButton *widget, void *user_data)
{
	image_document_redo(((myapp *) user_data)->doc);
	myapp_drawframe_noskip(((myapp *) user_data));
	myapp_reflect_layer_status(((myapp *) user_data));
}

void myapp_on_btn_center_clicked(GtkButton *widget, void *user_data)
{
	image_document_viewport_align_center(((myapp *) user_data)->doc);
	myapp_update_scroll_controls(((myapp *) user_data));
	myapp_drawframe_noskip(((myapp *) user_data));
}

void myapp_on_btn_zoom100_clicked(GtkButton *widget, void *user_data)
{
	image_document_viewport_zoom_at_center(((myapp *) user_data)->doc, 1);

	myapp_update_zoom_controls(((myapp *) user_data));
	myapp_drawframe_noskip(((myapp *) user_data));
}

void myapp_on_btn_zoomfit_clicked(GtkButton *widget, void *user_data)
{
	image_document_viewport_zoom_to_fit(((myapp *) user_data)->doc);

	myapp_update_zoom_controls(((myapp *) user_data));
	myapp_drawframe_noskip(((myapp *) user_data));
}

void myapp_on_btn_zoomin_clicked(GtkButton *widget, void *user_data)
{
	image_document_viewport_zoom_at_center(((myapp *) user_data)->doc, ((myapp *) user_data)->doc->vpzoom + ZOOMSTEP);

	myapp_update_zoom_controls(((myapp *) user_data));
	myapp_drawframe_noskip(((myapp *) user_data));
}

void myapp_on_btn_zoomout_clicked(GtkButton *widget, void *user_data)
{
	double zoom = ((myapp *) user_data)->doc->vpzoom - ZOOMSTEP;

	assert(zoom >= ZOOMSTEP); /* ui.ngg:1601 */

	image_document_viewport_zoom_at_center(((myapp *) user_data)->doc, zoom);

	myapp_update_zoom_controls(((myapp *) user_data));
	myapp_drawframe_noskip(((myapp *) user_data));
}

void myapp_on_chk_bg_visible_toggled(GtkCheckButton *widget, void *user_data)
{
	image_document_set_bgvisible(((myapp *) user_data)->doc, gtk_toggle_button_get_active((GtkToggleButton *) widget));
	myapp_drawframe_noskip(((myapp *) user_data));
}

void myapp_on_chk_fg_visible_toggled(GtkCheckButton *widget, void *user_data)
{
	image_document_set_fgvisible(((myapp *) user_data)->doc, gtk_toggle_button_get_active((GtkToggleButton *) widget));
	myapp_drawframe_noskip(((myapp *) user_data));
}

char * myapp_prompt_for_export_filename(myapp *this)
{
	GtkNativeDialog *_ngg_tmp_174;
	GtkFileChooserNative *_ngg_tmp_176_dlg = gtk_file_chooser_native_new("Save File", this->wnd, GTK_FILE_CHOOSER_ACTION_SAVE, "_Save", "_Cancel");
	gtk_file_chooser_set_do_overwrite_confirmation((GtkFileChooser *) _ngg_tmp_176_dlg, true);

	_ngg_tmp_174 = (GtkNativeDialog *) _ngg_tmp_176_dlg;
	GtkNativeDialog *dlg = _ngg_tmp_174;

	GtkFileFilter *filter = gtk_file_filter_new();
	gtk_file_filter_add_mime_type(filter, "image/png");
	gtk_file_filter_set_name(filter, "*.png");
	gtk_file_chooser_add_filter((GtkFileChooser *) dlg, filter);

	char * _ngg_tmp_177;
	int res = gtk_native_dialog_run(dlg);

	char * fnam = NULL;

	if(res == GTK_RESPONSE_ACCEPT) {
		fnam = gtk_file_chooser_get_filename((GtkFileChooser *) dlg);
	}

	g_object_unref((GObject *) dlg);

	_ngg_tmp_177 = fnam;
	return _ngg_tmp_177;
}

char * myapp_prompt_for_open_filename(myapp *this)
{
	GtkNativeDialog *_ngg_tmp_178;
	GtkFileChooserNative *_ngg_tmp_180_dlg = gtk_file_chooser_native_new("Open File", this->wnd, GTK_FILE_CHOOSER_ACTION_OPEN, "_Open", "_Cancel");
	gtk_file_chooser_set_do_overwrite_confirmation((GtkFileChooser *) _ngg_tmp_180_dlg, true);

	_ngg_tmp_178 = (GtkNativeDialog *) _ngg_tmp_180_dlg;
	GtkNativeDialog *dlg = _ngg_tmp_178;

	GtkFileFilter *filter = gtk_file_filter_new();
	gtk_file_filter_add_mime_type(filter, "image/x-xcf");
	gtk_file_filter_set_name(filter, "*.xcf");
	gtk_file_chooser_add_filter((GtkFileChooser *) dlg, filter);

	char * _ngg_tmp_181;
	int res = gtk_native_dialog_run(dlg);

	char * fnam = NULL;

	if(res == GTK_RESPONSE_ACCEPT) {
		fnam = gtk_file_chooser_get_filename((GtkFileChooser *) dlg);
	}

	g_object_unref((GObject *) dlg);

	_ngg_tmp_181 = fnam;
	return _ngg_tmp_181;
}

char * myapp_prompt_for_save_as_filename(myapp *this)
{
	GtkNativeDialog *_ngg_tmp_182;
	GtkFileChooserNative *_ngg_tmp_184_dlg = gtk_file_chooser_native_new("Save File", this->wnd, GTK_FILE_CHOOSER_ACTION_SAVE, "_Save", "_Cancel");
	gtk_file_chooser_set_do_overwrite_confirmation((GtkFileChooser *) _ngg_tmp_184_dlg, true);

	_ngg_tmp_182 = (GtkNativeDialog *) _ngg_tmp_184_dlg;
	GtkNativeDialog *dlg = _ngg_tmp_182;

	GtkFileFilter *filter = gtk_file_filter_new();
	gtk_file_filter_add_mime_type(filter, "image/x-xcf");
	gtk_file_filter_set_name(filter, "*.xcf");
	gtk_file_chooser_add_filter((GtkFileChooser *) dlg, filter);

	char * _ngg_tmp_185;
	int res = gtk_native_dialog_run(dlg);

	char * fnam = NULL;

	if(res == GTK_RESPONSE_ACCEPT) {
		fnam = gtk_file_chooser_get_filename((GtkFileChooser *) dlg);
	}

	g_object_unref((GObject *) dlg);

	_ngg_tmp_185 = fnam;
	return _ngg_tmp_185;
}

void myapp_on_da_sizeallocate(GtkDrawingArea *widget, GdkRectangle *nggevent_allocation, void *user_data)
{
	if(!gtk_widget_get_mapped((GtkWidget *) widget)) {
		return;
	}

	myapp_reserve_cairo_surface(((myapp *) user_data), nggevent_allocation->width, nggevent_allocation->height);

	image_document_viewport_set_size(((myapp *) user_data)->doc, nggevent_allocation->width, nggevent_allocation->height);

	myapp_update_scroll_controls(((myapp *) user_data));

	myapp_drawframe_noskip(((myapp *) user_data));
}

void myapp_on_hscroll_valuechanged(GtkRange *widget, void *user_data)
{
	if(((myapp *) user_data)->was_autoscroll) {
		return;
	}

	image_document_viewport_set_offsetx(((myapp *) user_data)->doc, (int) (0 - gtk_range_get_value(widget)));
	myapp_drawframe_noskip(((myapp *) user_data));
}

void myapp_on_sldr_brush_x_changed(EntrySlider *widget, void *user_data)
{
	if(!((myapp *) user_data)->doc) {
		return;
	}

	((myapp *) user_data)->doc->drawparams.brushparams.aaradius_circle1 = entry_slider_get_value(((myapp *) user_data)->sldr_brush_aaradius_circle1);

	((myapp *) user_data)->doc->drawparams.brushparams.opacity = entry_slider_get_value(((myapp *) user_data)->sldr_brush_opacity);

	((myapp *) user_data)->doc->drawparams.brushparams.scatter_density = entry_slider_get_value(((myapp *) user_data)->sldr_brush_scatter_density);

	((myapp *) user_data)->doc->drawparams.brushparams.scatter_radius = entry_slider_get_value(((myapp *) user_data)->sldr_brush_scatter_radius);

	((myapp *) user_data)->doc->drawparams.brushparams.softness = entry_slider_get_value(((myapp *) user_data)->sldr_brush_softness);

	myapp_repreview_brush(((myapp *) user_data));
}

void myapp_on_vscroll_valuechanged(GtkRange *widget, void *user_data)
{
	if(((myapp *) user_data)->was_autoscroll) {
		return;
	}

	image_document_viewport_set_offsety(((myapp *) user_data)->doc, (int) (0 - gtk_range_get_value(widget)));
	myapp_drawframe_noskip(((myapp *) user_data));
}

void myapp_pick_tool(myapp *this, Tool tool, _Bool erase)
{
	switch(tool) {
	case TOOL_BRUSH:
	{
		this->doc->drawparams.active_tool = TOOL_BRUSH;
		this->doc->drawparams.erase = erase;
		break;
	}
	case TOOL_PENCIL:
	{
		this->doc->drawparams.active_tool = TOOL_PENCIL;
		this->doc->drawparams.erase = false;
		break;
	}
	case TOOL_EYEDROPPER:
	{
		this->doc->drawparams.active_tool = TOOL_EYEDROPPER;
		break;
	}
	case TOOL_FLOODFILL:
	{
		this->doc->drawparams.active_tool = TOOL_FLOODFILL;
		break;
	}
	case TOOL_PAN:
	{
		this->doc->drawparams.active_tool = TOOL_PAN;
		break;
	}
	}

	myapp_set_canvas_cursor_for_active_tool(this);
}

void myapp_reserve_cairo_surface(myapp *this, int w, int h)
{
	assert(w > 0); /* ui.ngg:1754 */

	assert(h > 0); /* ui.ngg:1755 */

	if(this->surf && (cairo_image_surface_get_width(this->surf) >= w) && (cairo_image_surface_get_height(this->surf) >= h)) {
		return;
	}

	cairo_surface_t *_ngg_tmp_7 = gdk_window_create_similar_image_surface(gtk_widget_get_window((GtkWidget *) this->da), CAIRO_FORMAT_RGB24, w, h, 0);
	if(this->surf) {
		cairo_surface_destroy(this->surf);
	}

	this->surf = _ngg_tmp_7;
}

void myapp_update_brush_size_view(myapp *this)
{
	myapp_repreview_brush(this);
	myapp_set_canvas_cursor_for_active_tool(this);
}

void myapp_update_history_controls(myapp *this)
{
	_Bool _tmp_1 = image_document_can_undo(this->doc);
	gtk_widget_set_sensitive((GtkWidget *) this->btn_undo, _tmp_1);
	_Bool _tmp_2 = image_document_can_redo(this->doc);
	gtk_widget_set_sensitive((GtkWidget *) this->btn_redo, _tmp_2);
	_Bool _tmp_3 = image_document_can_undo(this->doc);
	gtk_widget_set_sensitive((GtkWidget *) this->mni_edit_undo, _tmp_3);
	_Bool _tmp_4 = image_document_can_redo(this->doc);
	gtk_widget_set_sensitive((GtkWidget *) this->mni_edit_redo, _tmp_4);
}

void myapp_update_scroll_controls(myapp *this)
{
	if(!this->doc->preview) {
		return;
	}

	this->was_autoscroll = true;

	int curx = 0 - this->doc->vpx;
	int cury = 0 - this->doc->vpy;

	assert(this->doc->preview);
	int psx = (this->doc->preview)->width;
	assert(this->doc->preview);
	int psy = (this->doc->preview)->height;

	int xmax = imax2((int) (this->doc->vpzoom * this->doc->composite->width), curx + psx);
	int ymax = imax2((int) (this->doc->vpzoom * this->doc->composite->height), cury + psy);

	int xmin = imin2(curx, 0);
	int ymin = imin2(cury, 0);

	assert(xmin <= xmax); /* ui.ngg:1817 */
	assert(ymin <= ymax); /* ui.ngg:1818 */
	assert(curx >= xmin && curx <= xmax); /* ui.ngg:1819 */

	assert(cury >= ymin && cury <= ymax); /* ui.ngg:1820 */

	gtk_range_set_range((GtkRange *) this->hscroll, xmin, xmax);
	gtk_range_set_range((GtkRange *) this->vscroll, ymin, ymax);

	gtk_adjustment_set_page_size(gtk_range_get_adjustment((GtkRange *) this->hscroll), psx);
	gtk_adjustment_set_page_size(gtk_range_get_adjustment((GtkRange *) this->vscroll), psy);

	gtk_range_set_value((GtkRange *) this->hscroll, curx);
	gtk_range_set_value((GtkRange *) this->vscroll, cury);

	this->was_autoscroll = false;
}

void myapp_update_zoom_controls(myapp *this)
{
	_Bool zoomin_enabled = myapp_can_zoom_in(this);
	_Bool zoomout_enabled = myapp_can_zoom_out(this);

	gtk_widget_set_sensitive((GtkWidget *) this->btn_zoomin, zoomin_enabled);
	gtk_widget_set_sensitive((GtkWidget *) this->mni_view_zoomin, zoomin_enabled);
	gtk_widget_set_sensitive((GtkWidget *) this->btn_zoomout, zoomout_enabled);
	gtk_widget_set_sensitive((GtkWidget *) this->mni_view_zoomout, zoomout_enabled);

	size_t _tmp_catpos = 0u;
	char *_tmp_1 = (char *) calloc((size_t) ((1u) + (16u) + (1u)), sizeof(char));
	if(_tmp_1 == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	char * _tmp_catstr = (char *) _tmp_1;
	snprintf(_tmp_catstr + _tmp_catpos, 16u, "%d", (int) (100 * this->doc->vpzoom));
	_tmp_catpos = strlen(_tmp_catstr);
	_tmp_catstr[_tmp_catpos++] = '%';
	_tmp_catstr[_tmp_catpos] = '\0';
	char * tmplbl = _tmp_catstr;
	gtk_label_set_label(this->lbl_zoom, tmplbl);
	myapp_update_scroll_controls(this);
	if(tmplbl) {
		free(tmplbl);
	}
}

void myapp_process_da_event(myapp *this, int event_type, int x, int y, double pressure, GdkScrollDirection scroll_direction)
{
	switch(event_type) {
	case GDK_BUTTON_PRESS:
	case GDK_TOUCH_BEGIN:
	{
		if((this->doc->drawparams.active_tool == TOOL_EYEDROPPER) || (this->doc->drawparams.active_tool == TOOL_FLOODFILL)) {
			return;
		}

		if(this->doc->drawparams.active_tool == TOOL_PAN) {
			gdk_window_set_event_compression(gtk_widget_get_window((GtkWidget *) this->da), true);
			myapp_set_canvas_cursor(this, "grabbing");
			image_document_pan_begin(this->doc, x, y);
			return;
		}

		image_document_pen_down(this->doc, x, y, pressure);
		myapp_drawframe_noskip(this);
		break;
	}
	case GDK_BUTTON_RELEASE:
	case GDK_TOUCH_CANCEL:
	case GDK_TOUCH_END:
	{
		switch(this->doc->drawparams.active_tool) {
		case TOOL_EYEDROPPER:
		{
			image_document_dip_eyedropper(this->doc, x, y);
			myapp_reflect_color_status(this);
			return;
			break;
		}
		case TOOL_FLOODFILL:
		{
			image_document_floodfill(this->doc, x, y);
			break;
		}
		case TOOL_PAN:
		{
			image_document_pan_update(this->doc, x, y);

			myapp_update_scroll_controls(this);

			image_document_pan_end(this->doc);
			myapp_set_canvas_cursor(this, "grab");
			gdk_window_set_event_compression(gtk_widget_get_window((GtkWidget *) this->da), false);
			break;
		}
		default:
		{
			image_document_pen_up(this->doc, x, y, pressure);
			break;
		}
		}

		myapp_drawframe_noskip(this);
		break;
	}
	case GDK_MOTION_NOTIFY:
	case GDK_TOUCH_UPDATE:
	{
		if(this->doc->mouse_is_down) {
			switch(this->doc->drawparams.active_tool) {
			case TOOL_BRUSH:
			case TOOL_PENCIL:
			{
				image_document_pen_stroke(this->doc, x, y, pressure);
				myapp_drawframe_noskip(this);
				break;
			}
			case TOOL_PAN:
			{
				image_document_pan_update(this->doc, x, y);

				myapp_update_scroll_controls(this);

				myapp_drawframe_noskip(this);
				break;
			}
			default:
			{
				break;
			}
			}
		}
		break;
	}
	case GDK_SCROLL:
	{
		switch(scroll_direction) {
		case GDK_SCROLL_UP:
		{
			if(myapp_can_zoom_in(this)) {
				double zoom = this->doc->vpzoom + ZOOMSTEP;
				image_document_viewport_zoom_at(this->doc, x, y, zoom);
			}
			break;
		}
		case GDK_SCROLL_DOWN:
		{
			if(myapp_can_zoom_out(this)) {
				double zoom = this->doc->vpzoom - ZOOMSTEP;
				image_document_viewport_zoom_at(this->doc, x, y, zoom);
			}
			break;
		}
		case GDK_SCROLL_LEFT:
		case GDK_SCROLL_RIGHT:
		case GDK_SCROLL_SMOOTH:
		{
			break;
		}
		}

		myapp_update_zoom_controls(this);
		myapp_drawframe_noskip(this);
		break;
	}
	default:
	{
		break;
	}
	}
}

VaraRect myapp_copy_preview_to_cairo_surface(myapp *this)
{
	assert(this->doc); /* ui.ngg:1974 */

	VaraRect dirtyrect = image_document_update_preview(this->doc);

	assert(this->doc->preview);
	copy_image_region_to_cairo_surface(this->doc->preview, this->surf, dirtyrect);

	return dirtyrect;
}

void myapp_clear_cairo_surface(myapp *this)
{
	int y;
	assert(this->surf); /* ui.ngg:1988 */

	int stride = cairo_image_surface_get_stride(this->surf);
	unsigned char *ibuf = cairo_image_surface_get_data(this->surf);

	size_t rowpos = 0u;
	for(y = 0; y < cairo_image_surface_get_height(this->surf); y += 1) {
		int x;
		size_t pixpos = rowpos;
		for(x = 0; x < cairo_image_surface_get_width(this->surf); x += 1) {
			nan_copy_pixel_to_rgb24(srgbpixel2linear(PIXEL_VPBG), ibuf + pixpos);

			pixpos = pixpos + 4;
		}

		rowpos = rowpos + stride;
	}

	cairo_surface_mark_dirty(this->surf);
}

void myapp_drawframe(myapp *this)
{
	if(gtk_events_pending()) {
		return;
	}

	myapp_drawframe_noskip(this);
}

void myapp_drawframe_noskip(myapp *this)
{
	if(this->doc && this->doc->preview) {
		VaraRect dirtyrect = myapp_copy_preview_to_cairo_surface(this);

		if(!region_is_zero(dirtyrect)) {
			gtk_widget_queue_draw_area((GtkWidget *) this->da, dirtyrect.x, dirtyrect.y, dirtyrect.w, dirtyrect.h);
		}
	} else {
		myapp_clear_cairo_surface(this);
		gtk_widget_queue_draw((GtkWidget *) this->da);
	}
}

void myapp_on_mni_help_about_activate(GtkMenuItem *widget, void *user_data)
{
	GtkAboutDialog *dlg = (GtkAboutDialog *) gtk_about_dialog_new();
	gtk_about_dialog_set_program_name(dlg, PROGRAM_NAME);
	gtk_about_dialog_set_comments(dlg, "Just draw.");
	gtk_about_dialog_set_logo_icon_name(dlg, "vara"); // FLATPAK_DELETE
	// FLATPAK_UNCOMMENT gtk_about_dialog_set_logo_icon_name(dlg, "in.co.nandakumar.vara");
	const char * authors[2] = {"Nandakumar Edamana", NULL};
	gtk_about_dialog_set_authors(dlg, authors);

	gtk_about_dialog_set_copyright(dlg, "Copyright (C) 2021, 2023, 2024, 2025 Nandakumar Edamana <contact@nandakumar.co.in>");
	gtk_about_dialog_set_license_type(dlg, GTK_LICENSE_GPL_3_0_ONLY);
	gtk_about_dialog_set_version(dlg, VERSION);
	gtk_about_dialog_set_website(dlg, "https://nandakumar.co.in/software/vara/");
	gtk_window_set_transient_for((GtkWindow *) dlg, ((myapp *) user_data)->wnd);
	int _ngg_tmp_186;
	int res = gtk_dialog_run((GtkDialog *) dlg);
	gtk_widget_destroy((GtkWidget *) dlg);
	_ngg_tmp_186 = res;
}

void myapp_on_btn_new_doc_clicked(GtkButton *widget, void *user_data)
{
	if(!myapp_prompt_close_document(((myapp *) user_data))) {
		return;
	}

	NewDocDialog *ndlg = (NewDocDialog *) malloc(sizeof(NewDocDialog));
	if(ndlg == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	new_doc_dialog_construct(ndlg, ((myapp *) user_data)->wnd, MAXWIDTH);

	_ngg_tuple_NewDocDialog__run _ngg_tmp_1 = new_doc_dialog_run(ndlg);
	int h = _ngg_tmp_1.m2;
	int w = _ngg_tmp_1.m1;
	_Bool ok = _ngg_tmp_1.m0;

	if(!ok) {
		if(ndlg) {
			new_doc_dialog_destruct(ndlg);
			free(ndlg);
		}

		return;
	}

	ImageDocument *_tmp_1 = (ImageDocument *) malloc(sizeof(ImageDocument));
	if(_tmp_1 == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	image_document_construct(_tmp_1, w, h, default_drawparams(), true);
	myapp_set_document(((myapp *) user_data), _tmp_1);
	if(ndlg) {
		new_doc_dialog_destruct(ndlg);
		free(ndlg);
	}
}

void myapp_repreview_brush(myapp *this)
{
	if(this->disable_brush_preview) {
		return;
	}

	DrawingParams dp = this->doc->drawparams;
	dp.active_tool = TOOL_BRUSH;
	dp.erase = false;

	assert(this->iv_brushpreview->img);
	draw_brush_preview(this->iv_brushpreview->img, dp, false);

	image_view_queue_draw(this->iv_brushpreview);
}

void myapp_destruct(myapp *this)
{
	if(this->ivw_ballpoint) {
		this->ivw_ballpoint->_ngg_vtab_image_view.destruct(this->ivw_ballpoint);
		free(this->ivw_ballpoint);
	}

	if(this->ivw_charcoal) {
		this->ivw_charcoal->_ngg_vtab_image_view.destruct(this->ivw_charcoal);
		free(this->ivw_charcoal);
	}

	if(this->ivw_crayon) {
		this->ivw_crayon->_ngg_vtab_image_view.destruct(this->ivw_crayon);
		free(this->ivw_crayon);
	}

	if(this->ivw_pencil) {
		this->ivw_pencil->_ngg_vtab_image_view.destruct(this->ivw_pencil);
		free(this->ivw_pencil);
	}

	if(this->ivw_round) {
		this->ivw_round->_ngg_vtab_image_view.destruct(this->ivw_round);
		free(this->ivw_round);
	}

	if(this->ivw_round_pressure_size) {
		this->ivw_round_pressure_size->_ngg_vtab_image_view.destruct(this->ivw_round_pressure_size);
		free(this->ivw_round_pressure_size);
	}

	if(this->ivw_soft_round) {
		this->ivw_soft_round->_ngg_vtab_image_view.destruct(this->ivw_soft_round);
		free(this->ivw_soft_round);
	}

	if(this->toolicons) {
		tool_icons_destruct((ToolIcons *) this->toolicons);
		free(this->toolicons);
	}

	if(this->doc) {
		image_document_destruct(this->doc);
		free(this->doc);
	}

	if(this->surf) {
		cairo_surface_destroy(this->surf);
	}
}

void on_da_event(GtkWidget *w, GdkEvent *event, myapp *app)
{
	_ngg_tuple_ngg_coords_from_event _ngg_tmp_0 = ngg_coords_from_event(event);
	double y = _ngg_tmp_0.m1;
	double x = _ngg_tmp_0.m0;

	double pressure = 0.0;
	bool present = gdk_event_get_axis(event, GDK_AXIS_PRESSURE, &pressure);
	if(!present) pressure = 1;
	GdkScrollDirection dir = (GdkScrollDirection) 0;
	if(event->type == GDK_SCROLL) {
		gdk_event_get_scroll_direction(event, &dir);
	}

	myapp_process_da_event(app, event->type, (int) x, (int) y, pressure, dir);
}

void on_da_paint(GtkWidget *w, cairo_t *cr, myapp *app)
{
	cairo_set_source_surface(cr, app->surf, 0, 0);

	cairo_paint(cr);
}

_Bool on_wnd_deleteevent(GtkWidget *wgt, GdkEvent *event, myapp *app)
{
	if(!myapp_prompt_close_document(app)) {
		return true;
	}

	gtk_main_quit();

	return false;
}

void draw_brush_preview(Image *img, DrawingParams dpcopy, _Bool dot_only)
{
	Pixel PIXEL_LIGHT_GRAY = (Pixel) { {0.8, 0.8, 0.8, 1} };

	image_fill(img, srgbpixel2linear(PIXEL_LIGHT_GRAY));

	image_fill_region(img, LINEAR_PIXEL_WHITE, (VaraRect) { 1, 1, img->width - 2, img->height - 2 });

	dpcopy.fgcolor = LINEAR_PIXEL_BLACK;
	dpcopy.oldpressure = 1;

	double radius = dpcopy.brushparams.siz / 2.0;
	double ymid = img->height / 2.0;

	if(dot_only) {
		double xmid = img->width / 2.0;

		dpcopy.pressure = 1;
		image_line(img, xmid, ymid, xmid, ymid, dpcopy);
	} else {
		int padding = 5;

		dpcopy.pressure = 0;
		image_line(img, padding + radius, ymid, img->width - radius - padding, ymid, dpcopy);
	}
}

ImageView * brushpreview_widget_new(BrushParams brushparams)
{
	ImageView *iv = (ImageView *) malloc(sizeof(ImageView));
	if(iv == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	image_view_construct(iv);
	Image *img = (Image *) malloc(sizeof(Image));
	if(img == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	image_construct(img, 36, 24, 255);

	DrawingParams dp = default_drawparams();
	dp.brushparams = brushparams;
	dp.active_tool = TOOL_BRUSH;
	draw_brush_preview(img, dp, false);

	image_view_set_image(iv, img);

	return iv;
}

_Bool probably_inside_container()
{
	size_t _ngg_tmp_5;
	const char * id;
	const char * containerenvs[4] = {"container", "FLATPAK_ID", "SNAP", "APPIMAGE"};

	for(_ngg_tmp_5 = 0u; _ngg_tmp_5 < (sizeof containerenvs / sizeof containerenvs[0]); _ngg_tmp_5 += (1u)) {
		id = containerenvs[_ngg_tmp_5];
		if(getenv(id)) {
			return true;
		}
	}

	return false;
}

char * append_ext_if_needed_and_possible(const char * fnam, const char * ext)
{
	char *_tmp_2 = (char *) calloc((size_t) (strlen(fnam) + (1u)), sizeof(char));
	if(_tmp_2 == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	char * _tmp_1 = (char *) _tmp_2;
	memcpy(_tmp_1, fnam, strlen(fnam) + (1u));
	return _tmp_1;
}

char * append_png_if_needed_and_possible(const char * fnam)
{
	return append_ext_if_needed_and_possible(fnam, "png");
}

char * append_xcf_if_needed_and_possible(const char * fnam)
{
	return append_ext_if_needed_and_possible(fnam, "xcf");
}

void set_tool_icon(GtkButton *btn, Image *img)
{
	ImageView *iv = (ImageView *) malloc(sizeof(ImageView));
	if(iv == NULL) {
		perror(NULL);
		exit(EXIT_FAILURE);
	}

	image_view_construct(iv);
	image_view_set_image(iv, img);

	gtk_button_set_image(btn, image_view_get_native_widget(iv));
	gtk_button_set_label(btn, NULL);
	gtk_button_set_relief(btn, GTK_RELIEF_NONE);
}

CommandLineOptions command_line_options_default()
{
	CommandLineOptions s;
	s.static_cursor = false;
	return s;
}

SimpleHelpItem simple_help_item_default()
{
	SimpleHelpItem s;
	s.title = "";
	s.message = "";
	return s;
}
