/* ui.h
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#ifndef N96_DRAW_ui_h
#define N96_DRAW_ui_h

typedef struct Image Image;
typedef struct CommandLineOptions CommandLineOptions;
typedef struct SimpleHelpItem SimpleHelpItem;
typedef struct myapp myapp;
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "doc.h"
#include "brushes.h"
#include "defaults.h"
#include "entryslider.h"
#include "helpmenuitem.h"
#include "imageview.h"
#include "inputdialog.h"
#include "newdocdialog.h"
#include "quickpalette.h"
#include "ui-icons.h"
#include "xcf-read.h"
#include "xcf-write.h"
#include <cairo.h>
#define PROGRAM_NAME ("Vara")
#define VERSION ("0.1.251018")
#define DEFWIDTH_MWND (1366)
#define DEFHEIGHT_MWND (720)
#define DEFWIDTH_CAIRO (1920)
#define DEFHEIGHT_CAIRO (1080)
#define MINWIDTH_MWND (1024)
#define MINHEIGHT_MWND (400)
#define MINWIDTH_LBL_BRUSH_SIZE (24)
#define MINWIDTH_LBL_ZOOM_SIZE (48)
struct CommandLineOptions {
	_Bool static_cursor;
};

extern CommandLineOptions clopts;
extern double ZOOMSTEP;
#define MAXWIDTH (4096)
struct SimpleHelpItem {
	const char * title;
	const char * message;
};

extern SimpleHelpItem helpitems[2];
struct myapp {
	EntrySlider *sldr_layer_opacity;
	GtkListBox *lst_layers;
	GtkScrolledWindow *sw_layers;
	GtkToolButton *btn_layer_delete;
	GtkToolButton *btn_layer_rename;
	GtkToolButton *btn_layer_move_down;
	GtkToolButton *btn_layer_move_up;
	GtkToolButton *btn_layer_new;
	GtkToolbar *tbr_layers;
	GtkBox *box_layers;
	EntrySlider *sldr_color_lit;
	EntrySlider *sldr_color_sat;
	EntrySlider *sldr_color_hue;
	GtkBox *box_coloropts;
	GtkCheckButton *chk_subpixel_when_zoomed;
	EntrySlider *sldr_stroke_smoothness;
	GtkBox *box_strokeopts;
	GtkCheckButton *chk_scatter_take_pressure;
	EntrySlider *sldr_brush_scatter_density;
	EntrySlider *sldr_brush_scatter_radius;
	GtkRadioButton *rad_scatter_type_square;
	GtkRadioButton *rad_scatter_type_circle;
	GtkRadioButton *rad_scatter_type_none;
	GtkLabel *lbl_scatter_type;
	GtkBox *hbx_scatter_type;
	EntrySlider *sldr_brush_aaradius_circle1;
	EntrySlider *sldr_brush_softness;
	EntrySlider *sldr_brush_opacity;
	GtkCheckButton *chk_pressure;
	GtkComboBoxText *cbo_brush_engine;
	GtkBox *box_brushopts;
	GtkLabel *lbl_zoom;
	GtkToolItem *tbi_lbl_zoom;
	GtkToolButton *btn_zoomin;
	GtkToolButton *btn_zoomout;
	GtkToolButton *btn_zoom100;
	GtkToolButton *btn_center;
	GtkToolbar *tbr_zoom;
	GtkFrame *fme_zoom;
	QuickPalette *quickpalette;
	GtkButton *btn_layer_fillbgcolor;
	GtkBox *box_layeracts;
	GtkFrame *fme_layeracts;
	GtkCheckButton *chk_bg_visible;
	GtkCheckButton *chk_fg_visible;
	GtkBox *box_layer_visibility;
	GtkFrame *fme_layer_visibility;
	GtkButton *btn_more_layers;
	GtkRadioButton *btn_bglayer;
	GtkRadioButton *btn_fglayer;
	GtkBox *box_quicklayers;
	GtkFrame *fme_quicklayers;
	GtkBox *box_controls1;
	GtkButton *btn_export_doc;
	GtkBox *hbx_newdoc;
	GtkFrame *fme_newdoc;
	GtkBox *box_newdoc;
	GtkGrid *grd_bottom;
	GtkNotebook *nbk_advanced;
	GtkScrollbar *hscroll;
	GtkScrollbar *vscroll;
	GtkDrawingArea *da;
	GtkGrid *grd_viewport;
	GtkButton *btn_redo;
	GtkButton *btn_undo;
	GtkBox *box_history;
	GtkFrame *fme_history;
	GtkCheckButton *chk_advanced;
	GtkCheckButton *chk_scratch;
	GtkBox *box_advanced;
	GtkFrame *fme_advanced;
	GtkButton *btn_prebrush_soft_round;
	GtkButton *btn_prebrush_round_pressure_size;
	GtkButton *btn_prebrush_round;
	GtkButton *btn_prebrush_charcoal;
	GtkButton *btn_prebrush_crayon;
	GtkButton *btn_prebrush_pencil;
	GtkButton *btn_prebrush_ballpoint;
	GtkBox *box_brushes;
	GtkFrame *fme_brushes;
	ImageView *iv_brushpreview;
	GtkFrame *fme_brushpreview;
	GtkSpinButton *spn_brushsiz;
	GtkFrame *fme_brushsiz;
	GtkColorButton *btn_color;
	GtkBox *box_color;
	GtkFrame *fme_color;
	GtkRadioButton *btn_pan;
	GtkRadioButton *btn_floodfill;
	GtkRadioButton *btn_eyedropper;
	GtkRadioButton *btn_eraser;
	GtkRadioButton *btn_brush;
	GtkRadioButton *btn_pencil;
	GtkBox *box_tools;
	GtkFrame *fme_tools;
	GtkBox *box_controls2;
	GtkMenuItem *mni_help_about;
	GtkMenuItem *mni_help_topics;
	GtkMenu *mnu_help;
	GtkMenuItem *mni_help;
	GtkMenuItem *mni_tools_bminus;
	GtkMenuItem *mni_tools_bplus;
	GtkMenuItem *mni_tools_pan;
	GtkMenuItem *mni_tools_eyedropper;
	GtkMenuItem *mni_tools_floodfill;
	GtkMenuItem *mni_tools_eraser;
	GtkMenuItem *mni_tools_brush;
	GtkMenuItem *mni_tools_pencil;
	GtkMenu *mnu_tools;
	GtkMenuItem *mni_tools;
	GtkMenuItem *mni_view_layers;
	GtkSeparatorMenuItem *mnisep_view_1;
	GtkMenuItem *mni_view_zoomfit;
	GtkMenuItem *mni_view_zoom100;
	GtkMenuItem *mni_view_zoomout;
	GtkMenuItem *mni_view_zoomin;
	GtkMenu *mnu_view;
	GtkMenuItem *mni_view;
	GtkMenuItem *mni_edit_clear;
	GtkMenuItem *mni_edit_fill_bgcolor;
	GtkMenuItem *mni_edit_fill_fgcolor;
	GtkSeparatorMenuItem *mnisep_edit_1;
	GtkMenuItem *mni_edit_redo;
	GtkMenuItem *mni_edit_undo;
	GtkMenu *mnu_edit;
	GtkMenuItem *mni_edit;
	GtkMenuItem *mni_file_quit;
	GtkSeparatorMenuItem *mnisep_file_3;
	GtkMenuItem *mni_file_export_layer;
	GtkMenuItem *mni_file_export;
	GtkSeparatorMenuItem *mnisep_file_2;
	GtkMenuItem *mni_file_save_as;
	GtkSeparatorMenuItem *mnisep_file_1;
	GtkMenuItem *mni_file_open;
	GtkMenuItem *mni_file_new;
	GtkMenu *mnu_file;
	GtkMenuItem *mni_file;
	GtkMenuBar *mbr;
	GtkBox *box_main;
	GtkAccelGroup *accgrp;
	GtkWindow *wnd;
	_Bool was_autoscroll;
	_Bool disable_brush_preview;
	int curcursorsiz;
	_Bool curcursor_is_circle;
	int test_vara_logo_size;
	_Bool test_vara_logo_exit;
	ImageView *ivw_ballpoint;
	ImageView *ivw_charcoal;
	ImageView *ivw_crayon;
	ImageView *ivw_pencil;
	ImageView *ivw_round;
	ImageView *ivw_round_pressure_size;
	ImageView *ivw_soft_round;
	_Bool color_being_set_by_hsl;
	ToolIcons *toolicons;
	int layerstack_version;
	_Bool updating_lst_layers;
	ImageDocument *doc;
	cairo_surface_t *surf;
};

void myapp_construct(myapp *this, const char * infile_path);
_Bool myapp_can_zoom_in(myapp *this);
_Bool myapp_can_zoom_out(myapp *this);
_Bool myapp_prompt_close_document(myapp *this);
void myapp_reflect_brush_status(myapp *this);
void myapp_reflect_document_state(myapp *this);
void myapp_reflect_color_status(myapp *this);
void myapp_reflect_color_status_in_hsl(myapp *this, double r, double g, double b);
void myapp_reflect_layer_status(myapp *this);
void myapp_reflect_tool_status(myapp *this);
void myapp_set_canvas_cursor(myapp *this, const char * name);
void myapp_set_canvas_cursor_for_active_tool(myapp *this);
void myapp_set_document(myapp *this, ImageDocument *newdoc);
void myapp_after_set_document(myapp *this);
void myapp_on_btn_color_set(GtkColorButton *widget, void *user_data);
void myapp_on_btn_layer_delete_clicked(GtkToolButton *widget, void *user_data);
void myapp_on_btn_layer_move_down_clicked(GtkToolButton *widget, void *user_data);
void myapp_on_btn_layer_move_up_clicked(GtkToolButton *widget, void *user_data);
void myapp_on_btn_layer_new_clicked(GtkToolButton *widget, void *user_data);
void myapp_on_btn_layer_rename_clicked(GtkToolButton *widget, void *user_data);
void myapp_on_btn_more_layers_clicked(GtkButton *widget, void *user_data);
void myapp_on_quickpalette_colorset(QuickPalette *widget, LinearPixel eventcolor_linear, void *user_data);
void myapp_on_spn_brushsiz_changed(GtkSpinButton *widget, void *user_data);
void myapp_on_btn_tool_x_toggled(GtkCheckButton *widget, void *user_data);
void myapp_on_cbo_brush_engine_changed(GtkComboBox *widget, void *user_data);
void myapp_on_mni_file_open_activate(GtkMenuItem *widget, void *user_data);
void myapp_on_mni_file_save_as_activate(GtkMenuItem *widget, void *user_data);
void myapp_on_mni_file_quit_activate(GtkMenuItem *widget, void *user_data);
void myapp_on_mni_fill_bgcolor_activate(GtkMenuItem *widget, void *user_data);
void myapp_on_mni_fill_fgcolor_activate(GtkMenuItem *widget, void *user_data);
void myapp_on_mni_tool_x_toggled(GtkMenuItem *widget, void *user_data);
void myapp_on_mni_tools_bplus_activate(GtkMenuItem *widget, void *user_data);
void myapp_on_mni_tools_bminus_activate(GtkMenuItem *widget, void *user_data);
void myapp_on_btn_prebrush_clicked(GtkButton *widget, void *user_data);
void myapp_on_hsl_sliders_changed(EntrySlider *widget, void *user_data);
void myapp_on_lst_layers_row_selected(GtkListBox *widget, GtkListBoxRow *row, void *user_data);
void myapp_on_sldr_layer_opacity_changed(EntrySlider *widget, void *user_data);
void myapp_on_sldr_stroke_smoothness_changed(EntrySlider *widget, void *user_data);
void myapp_on_chk_advanced_toggled(GtkCheckButton *widget, void *user_data);
void myapp_on_chk_scatter_take_pressure_toggled(GtkCheckButton *widget, void *user_data);
void myapp_on_rad_scatter_type_x_toggled(GtkCheckButton *widget, void *user_data);
void myapp_on_chk_scratch_toggled(GtkCheckButton *widget, void *user_data);
void myapp_on_chk_subpixel_when_zoomed_toggled(GtkCheckButton *widget, void *user_data);
void myapp_on_chk_pressure_toggled(GtkCheckButton *widget, void *user_data);
void myapp_on_btn_xlayer_toggled(GtkCheckButton *widget, void *user_data);
void myapp_on_btn_clear_layer_clicked(GtkButton *widget, void *user_data);
void myapp_handle_fileio_err(myapp *this, VaraFileIOError err, _Bool saving);
void myapp_on_btn_export_doc_clicked(GtkButton *widget, void *user_data);
void myapp_on_btn_export_layer_clicked(GtkButton *widget, void *user_data);
void myapp_on_btn_undo_clicked(GtkButton *widget, void *user_data);
void myapp_on_btn_redo_clicked(GtkButton *widget, void *user_data);
void myapp_on_btn_center_clicked(GtkButton *widget, void *user_data);
void myapp_on_btn_zoom100_clicked(GtkButton *widget, void *user_data);
void myapp_on_btn_zoomfit_clicked(GtkButton *widget, void *user_data);
void myapp_on_btn_zoomin_clicked(GtkButton *widget, void *user_data);
void myapp_on_btn_zoomout_clicked(GtkButton *widget, void *user_data);
void myapp_on_chk_bg_visible_toggled(GtkCheckButton *widget, void *user_data);
void myapp_on_chk_fg_visible_toggled(GtkCheckButton *widget, void *user_data);
char * myapp_prompt_for_export_filename(myapp *this);
char * myapp_prompt_for_open_filename(myapp *this);
char * myapp_prompt_for_save_as_filename(myapp *this);
void myapp_on_da_sizeallocate(GtkDrawingArea *widget, GdkRectangle *nggevent_allocation, void *user_data);
void myapp_on_hscroll_valuechanged(GtkRange *widget, void *user_data);
void myapp_on_sldr_brush_x_changed(EntrySlider *widget, void *user_data);
void myapp_on_vscroll_valuechanged(GtkRange *widget, void *user_data);
void myapp_pick_tool(myapp *this, Tool tool, _Bool erase);
void myapp_reserve_cairo_surface(myapp *this, int w, int h);
void myapp_update_brush_size_view(myapp *this);
void myapp_update_history_controls(myapp *this);
void myapp_update_scroll_controls(myapp *this);
void myapp_update_zoom_controls(myapp *this);
void myapp_process_da_event(myapp *this, int event_type, int x, int y, double pressure, GdkScrollDirection scroll_direction);
VaraRect myapp_copy_preview_to_cairo_surface(myapp *this);
void myapp_clear_cairo_surface(myapp *this);
void myapp_drawframe(myapp *this);
void myapp_drawframe_noskip(myapp *this);
void myapp_on_mni_help_about_activate(GtkMenuItem *widget, void *user_data);
void myapp_on_btn_new_doc_clicked(GtkButton *widget, void *user_data);
void myapp_repreview_brush(myapp *this);
void myapp_destruct(myapp *this);
void on_da_event(GtkWidget *w, GdkEvent *event, myapp *app);
void on_da_paint(GtkWidget *w, cairo_t *cr, myapp *app);
_Bool on_wnd_deleteevent(GtkWidget *wgt, GdkEvent *event, myapp *app);
void draw_brush_preview(Image *img, DrawingParams dpcopy, _Bool dot_only);
ImageView * brushpreview_widget_new(BrushParams brushparams);
_Bool probably_inside_container();
char * append_ext_if_needed_and_possible(const char * fnam, const char * ext);
char * append_png_if_needed_and_possible(const char * fnam);
char * append_xcf_if_needed_and_possible(const char * fnam);
void set_tool_icon(GtkButton *btn, Image *img);
CommandLineOptions command_line_options_default();
SimpleHelpItem simple_help_item_default();

#endif /* N96_DRAW_ui_h */
