/* warpcore.h
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#ifndef N96E_WARPCORE_H
#define N96E_WARPCORE_H 1

#include "pixel.h"

// TODO
#define MAX_INTSTR 16

// TODO make user-confable
#define SCALING_AA_ENABLE 0
#define SCALING_AA_RADIUS 1

typedef struct Image Image;

Pixel nan_pixel_new(double r, double g, double b, double a);
void nan_img_alphen_pixel(Image * himg, int x, int y, double intensity);
void nan_img_darken_pixel(Image * himg, int x, int y, double intensity);
LinearPixel nan_img_get_linear_pixel(Image * himg, int x, int y);
LinearPixel nan_img_get_linear_pixel_for_scaling(Image * himg, double x, double y);
void nan_img_set_linear_pixel(Image * himg, int x, int y, LinearPixel pixel);
void nan_img_over_linear_pixel(Image * himg, int x, int y, LinearPixel pixel1);
void nan_img_write(Image * himg, const char * path);

#endif // N96E_WARPCORE_H
