/* winmain.c
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#ifdef WIN32

#include <assert.h>
#include <windows.h>
#include <gtk/gtk.h>

int main(int argc, char **argv);

int WINAPI wWinMain(
	HINSTANCE hInstance, HINSTANCE hPrevInstance, PWSTR pCmdLine, int nCmdShow)
{
	int argc;
	
	LPWSTR *wcargv = CommandLineToArgvW(pCmdLine, &argc);
	if(!wcargv) {
		fprintf(stderr,
			"vara: CommandLineToArgvW() failed with error code = %lu\n",
			GetLastError());

		exit(EXIT_FAILURE);
	}
	
	char **argv = malloc(argc * sizeof(char *));
	if(!argv) {
		perror("vara");
		exit(EXIT_FAILURE);
	}
	
	for(int i = 0; i < argc; i++) {
		argv[i] = wingtk_wcstr2u8(wcargv[i]);
		assert(argv[i]);
	}

	LocalFree(wcargv);

	int ret = main(argc, argv);
	
	free(argv);
	
	return ret;
}

#endif
