/* xcf-read.h
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#ifndef N96_DRAW_xcf_read_h
#define N96_DRAW_xcf_read_h

typedef struct XcfLayer XcfLayer;
typedef struct XcfLayerVector XcfLayerVector;
typedef struct XcfPrecision XcfPrecision;
typedef union XcfPropertyValue XcfPropertyValue;
typedef struct XcfProperty XcfProperty;
typedef struct XcfPointerVector XcfPointerVector;
typedef struct XcfTile XcfTile;
typedef struct XcfTileVector XcfTileVector;
typedef struct RawXcfDocument RawXcfDocument;
typedef struct _ngg_tuple_read_dimentions_from_xcf_fp _ngg_tuple_read_dimentions_from_xcf_fp;
typedef struct _ngg_tuple_read_xcf_pointer_from_fp _ngg_tuple_read_xcf_pointer_from_fp;
typedef struct _ngg_tuple_decode_xcf_precision _ngg_tuple_decode_xcf_precision;
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "doc.h"
#include "defaults.h"
#include <errno.h>
#include "pixel.h"
#include "xcf.h"
#define MAX_PPTYLEN (409600u)
#define MAX_LAYERNAM (4096u)
extern _Bool xcf_log_enabled;
struct XcfLayer {
	double alpha;
	_Bool visible;
	char * name;
	int width;
	int height;
	XcfTileVector *tiles;
};

struct XcfLayerVector {
	XcfLayer **arr;
	int alloccount;
	int count;
};

struct XcfPrecision {
	int bits;
	_Bool linear;
};

union XcfPropertyValue {
	_Bool bval;
	float fval;
	int ival;
	int ival2[2];
	unsigned int uval;
};

struct XcfProperty {
	unsigned int id;
	unsigned int length;
	XcfPropertyValue value;
	XcfProperty *next;
};

struct XcfPointerVector {
	long long *arr;
	int alloccount;
	int count;
};

struct XcfTile {
	LinearPixel buf[4096];
	int width;
	int height;
	Image *img;
};

struct XcfTileVector {
	XcfTile **arr;
	int alloccount;
	int count;
};

struct RawXcfDocument {
	XcfHeader hdr;
	XcfLayerVector *layers;
};

struct _ngg_tuple_read_dimentions_from_xcf_fp {
	int m0;
	int m1;
	_Bool m2;
};

struct _ngg_tuple_read_xcf_pointer_from_fp {
	long long m0;
	_Bool m1;
};

struct _ngg_tuple_decode_xcf_precision {
	XcfPrecision m0;
	_Bool m1;
};

void xcf_layer_set_alpha(XcfLayer *this, double alpha_in);
void xcf_layer_set_visible(XcfLayer *this, _Bool visible_in);
void xcf_layer_construct(XcfLayer *this, char * name, int width, int height, XcfTileVector *tiles);
void xcf_layer_destruct(XcfLayer *this);
void xcf_layer_vector_destruct(XcfLayerVector *this);
void xcf_layer_vector__resize(XcfLayerVector *this, int newcount);
void xcf_layer_vector_append(XcfLayerVector *this, XcfLayer *newitem);
void xcf_layer_vector_clear(XcfLayerVector *this);
void xcf_layer_vector_delete_all(XcfLayerVector *this);
XcfLayer * xcf_layer_vector_get_item(XcfLayerVector *this, int index);
XcfLayer * xcf_layer_vector_pop(XcfLayerVector *this);
void xcf_layer_vector_set_item(XcfLayerVector *this, int index, XcfLayer *itm);
int xcf_layer_vector_get_count(XcfLayerVector *this);
_Bool xcf_layer_vector_is_empty(XcfLayerVector *this);
void xcf_layer_vector_construct(XcfLayerVector *this);
void xcf_property_construct(XcfProperty *this, unsigned int id, unsigned int length, XcfPropertyValue value);
XcfProperty * xcf_property_get_next(XcfProperty *this);
void xcf_property_destruct(XcfProperty *this);
void xcf_pointer_vector__resize(XcfPointerVector *this, int newcount);
void xcf_pointer_vector_append(XcfPointerVector *this, long long newitem);
void xcf_pointer_vector_clear(XcfPointerVector *this);
long long xcf_pointer_vector_get_item(XcfPointerVector *this, int index);
long long xcf_pointer_vector_pop(XcfPointerVector *this);
void xcf_pointer_vector_set_item(XcfPointerVector *this, int index, long long itm);
int xcf_pointer_vector_get_count(XcfPointerVector *this);
_Bool xcf_pointer_vector_is_empty(XcfPointerVector *this);
void xcf_pointer_vector_destruct(XcfPointerVector *this);
void xcf_pointer_vector_construct(XcfPointerVector *this);
void xcf_tile_construct(XcfTile *this, int width, int height);
float xcf_tile_get_pixel_component(XcfTile *this, int x, int y, int channel);
void xcf_tile_set_byte(XcfTile *this, int x, int y, int channel, int bytidx, unsigned char bytval);
void xcf_tile_scale_pixel_alpha_component_from_byte(XcfTile *this, int x, int y);
void xcf_tile_scale_pixel_color_components_from_gamma_byte(XcfTile *this, int x, int y);
void xcf_tile_scale_pixel_color_components_from_linear_byte(XcfTile *this, int x, int y);
void xcf_tile_set_pixel_component(XcfTile *this, int x, int y, int channel, float value);
void xcf_tile_finish(XcfTile *this);
void xcf_tile_destruct(XcfTile *this);
void xcf_tile_vector_destruct(XcfTileVector *this);
void xcf_tile_vector__resize(XcfTileVector *this, int newcount);
void xcf_tile_vector_append(XcfTileVector *this, XcfTile *newitem);
void xcf_tile_vector_clear(XcfTileVector *this);
void xcf_tile_vector_delete_all(XcfTileVector *this);
XcfTile * xcf_tile_vector_get_item(XcfTileVector *this, int index);
XcfTile * xcf_tile_vector_pop(XcfTileVector *this);
void xcf_tile_vector_set_item(XcfTileVector *this, int index, XcfTile *itm);
int xcf_tile_vector_get_count(XcfTileVector *this);
_Bool xcf_tile_vector_is_empty(XcfTileVector *this);
void xcf_tile_vector_construct(XcfTileVector *this);
void raw_xcf_document_destruct(RawXcfDocument *this);
void raw_xcf_document_construct(RawXcfDocument *this);
long long get_max_pointer(FILE * fp);
ImageDocument * image_document_from_raw_xcf_document(RawXcfDocument *rawdoc, const char * path);
void logxcf(const char * path, const char * fmt, ...);
void perrorxcf(const char * path, FILE * fp, const char * fmt, ...);
_Bool read_and_ignore_xcf_pointers_from_fp(FILE * fp, const char * purpose, const char * path);
_ngg_tuple_read_dimentions_from_xcf_fp read_dimentions_from_xcf_fp(FILE * fp, const char * path);
ImageDocument * read_image_document_from_xcf(const char * path);
ImageDocument * read_image_document_from_xcf_fp(FILE * fp, const char * path);
RawXcfDocument * read_raw_xcf_document_from_fp(FILE * fp, const char * path);
char * read_string_pointers_from_xcf_fp(FILE * fp, const char * path);
XcfLayer * read_xcf_layer_from_fp(FILE * fp, long long offsethbo, XcfPrecision precision, const char * path);
_ngg_tuple_read_xcf_pointer_from_fp read_xcf_pointer_from_fp(FILE * fp, const char * path);
XcfPointerVector * read_xcf_pointers_from_fp(FILE * fp, const char * path, const char * purpose);
XcfTile * read_xcf_tile_from_fp(FILE * fp, long long offsethbo, int width, int height, XcfPrecision precision, int bpp, int nchannel, const char * path);
XcfTileVector * read_xcf_tiles_from_fp(FILE * fp, XcfPointerVector *tileptrs, int width, int height, XcfPrecision precision, int bpp, const char * path);
XcfProperty * read_raw_xcf_properties_from_fp(FILE * fp, const char * path);
_ngg_tuple_decode_xcf_precision decode_xcf_precision(unsigned int precision);
unsigned char get_byte_in_float(float f, int i);
float set_byte_in_float(float f, int i, unsigned char byt);
XcfPrecision xcf_precision_default();
_ngg_tuple_read_dimentions_from_xcf_fp _ngg_tuple_read_dimentions_from_xcf_fp_default();
_ngg_tuple_read_xcf_pointer_from_fp _ngg_tuple_read_xcf_pointer_from_fp_default();
_ngg_tuple_decode_xcf_precision _ngg_tuple_decode_xcf_precision_default();

#endif /* N96_DRAW_xcf_read_h */
