/* xcf-write.h
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#ifndef N96_DRAW_xcf_write_h
#define N96_DRAW_xcf_write_h

typedef struct PointerReplacement PointerReplacement;
typedef struct PointerReplacementVector PointerReplacementVector;
typedef struct PointerReplacementContext PointerReplacementContext;
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "doc.h"
#include "xcf.h"
struct PointerReplacement {
	long ptrloc;
	long ptrval;
};

struct PointerReplacementVector {
	PointerReplacement *arr;
	int alloccount;
	int count;
};

struct PointerReplacementContext {
	PointerReplacementVector *prvec;
};

extern unsigned int ZERO;
void pointer_replacement_vector__resize(PointerReplacementVector *this, int newcount);
void pointer_replacement_vector_append(PointerReplacementVector *this, PointerReplacement newitem);
void pointer_replacement_vector_clear(PointerReplacementVector *this);
PointerReplacement pointer_replacement_vector_get_item(PointerReplacementVector *this, int index);
PointerReplacement pointer_replacement_vector_pop(PointerReplacementVector *this);
void pointer_replacement_vector_set_item(PointerReplacementVector *this, int index, PointerReplacement itm);
int pointer_replacement_vector_get_count(PointerReplacementVector *this);
_Bool pointer_replacement_vector_is_empty(PointerReplacementVector *this);
void pointer_replacement_vector_destruct(PointerReplacementVector *this);
void pointer_replacement_vector_construct(PointerReplacementVector *this);
void pointer_replacement_context_apply(PointerReplacementContext *this, FILE * fp);
void pointer_replacement_context_put_placeholder(PointerReplacementContext *this, FILE * fp);
void pointer_replacement_context_set_ptrval(PointerReplacementContext *this, int idx, long val);
void pointer_replacement_context_destruct(PointerReplacementContext *this);
void pointer_replacement_context_construct(PointerReplacementContext *this);
int write_xcf_from_image_document(const char * path, ImageDocument *doc);
void nanxcf_write_absptrbe(FILE * fp, long long ptr);
void nanxcf_write_byte(FILE * fp, unsigned char b);
void nanxcf_write_float(FILE * fp, float x);
void nanxcf_write_int(FILE * fp, int n);
void nanxcf_write_layer(FILE * fp, Layer *layer);
void nanxcf_write_prop_apply_layer_mask(FILE * fp, _Bool apply);
void nanxcf_write_prop_blend_space(FILE * fp, int space);
void nanxcf_write_prop_composite_mode(FILE * fp, int mode);
void nanxcf_write_prop_composite_space(FILE * fp, int space);
void nanxcf_write_prop_compression_rle(FILE * fp);
void nanxcf_write_prop_end(FILE * fp);
void nanxcf_write_prop_float_opacity(FILE * fp, float opacity);
void nanxcf_write_prop_layer_mode(FILE * fp, unsigned int mode);
void nanxcf_write_prop_offsets_0_0(FILE * fp);
void nanxcf_write_prop_visible(FILE * fp, _Bool visible);
void nanxcf_write_relptr(FILE * fp, long long offset);
void nanxcf_write_string(FILE * fp, const char * s);
void nanxcf_write_uint(FILE * fp, unsigned int n);
void nanxcf_write_uint_prop(FILE * fp, unsigned int propid, unsigned int value);
void nanxcf_write_int_prop(FILE * fp, unsigned int propid, int value);
unsigned char get_byte_from_float(float f, int i);
PointerReplacement pointer_replacement_default();

#endif /* N96_DRAW_xcf_write_h */
