/* xcf.h
 * This file is part of Vara digital painting program
 * Copyright 2021, 2023, 2024, 2025 Nandakumar Edamana
 * Distributed under GNU General Public License, version 3
 */ 

#ifndef N96_DRAW_xcf_h
#define N96_DRAW_xcf_h

typedef struct XcfHeader XcfHeader;
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#define XCF_PROP_ACTIVE_LAYER (2u)
#define XCF_PROP_APPLY_MASK (11u)
#define XCF_PROP_BLEND_SPACE (37u)
#define XCF_PROP_COLOR_TAG (34u)
#define XCF_PROP_COMPOSITE_MODE (35u)
#define XCF_PROP_COMPOSITE_SPACE (36u)
#define XCF_PROP_COMPRESSION (17u)
#define XCF_PROP_EDIT_MASK (12u)
#define XCF_PROP_FLOAT_OPACITY (33u)
#define XCF_PROP_LINKED (9u)
#define XCF_PROP_LOCK_ALPHA (10u)
#define XCF_PROP_LOCK_CONTENT (28u)
#define XCF_PROP_LOCK_POSITION (32u)
#define XCF_PROP_MODE (7u)
#define XCF_PROP_OFFSETS (15u)
#define XCF_PROP_OPACITY (6u)
#define XCF_PROP_PARASITES (21u)
#define XCF_PROP_RESOLUTION (19u)
#define XCF_PROP_SHOW_MASK (13u)
#define XCF_PROP_TATTOO (20u)
#define XCF_PROP_UNIT (22u)
#define XCF_PROP_VISIBLE (8u)
#pragma pack(push, 1)
struct XcfHeader {
	char magic[9];
	char version[5];
	unsigned int width;
	unsigned int height;
	unsigned int base_type;
	unsigned int precision;
};

#pragma pack(pop)
XcfHeader xcf_header_default();

#endif /* N96_DRAW_xcf_h */
